package com.biz.crm.kms.business.invoice.order.local.service;

import com.biz.crm.kms.business.invoice.order.local.entity.OrderEntity;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderGoodsEntity;
import com.biz.crm.kms.business.invoice.order.local.model.OrderGrabSyncModel;

/**
 * 订货单商品表服务接口
 *
 * @author ning.zhang
 * @date 2022-10-12 16:37:43
 */
public interface OrderGoodsService {

  /**
   * 订货单商品数据转换
   * @param entity 订货单数据
   * @param syncModel 订货单数据解析数据
   */
  void transform(OrderEntity entity, OrderGrabSyncModel syncModel);

  /**
   * 构建商品信息
   *
   * @param orderGoodsEntity 商品信息
   * @param entity 订货单信息
   * @param syncModel  直营商品信息
   */
  void buildGoodsInfo(OrderGoodsEntity orderGoodsEntity, OrderEntity entity, OrderGrabSyncModel syncModel);

  /**
   * 清除转换数据
   *
   * @param entity 待清除单据
   */
  void clearTransformInfo(OrderGoodsEntity entity);
}
