package com.biz.crm.kms.business.invoice.order.local.service;

import com.biz.crm.kms.business.invoice.order.local.entity.OrderGrabEntity;
import com.biz.crm.kms.business.invoice.order.local.model.OrderGrabSyncModel;

import java.util.List;

/**
 * 订货单抓取数据(python)表服务接口
 *
 * @author ning.zhang
 * @date 2022-10-12 16:37:54
 */
public interface OrderGrabService {

  /**
   * 订货单自动解析定时任务
   */
  void executeTask();

  /**
   * 构建订货单抓单同步数据
   *
   * @param entities 订货单抓单数据
   * @return 订货单抓单同步数据
   */
  OrderGrabSyncModel buildOrderGrabSyncModel(List<OrderGrabEntity> entities);
}
