package com.biz.crm.kms.business.invoice.order.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderEntity;
import com.biz.crm.kms.business.invoice.order.local.model.OrderGrabSyncModel;
import com.biz.crm.kms.business.invoice.order.sdk.dto.OrderPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 订货单表服务接口
 *
 * @author ning.zhang
 * @date 2022-10-12 16:37:36
 */
public interface OrderService {

  /**
   * 订货单数据转换
   *
   * @param entity    订货单数据
   * @param syncModel 订货单数据解析数据
   * @return 订货单数据
   */
  OrderEntity transform(OrderEntity entity, OrderGrabSyncModel syncModel);

  /**
   * 构建订货单信息
   *
   * @param entity    订货单数据
   * @param syncModel 订货单数据解析数据
   */
  void buildOrderInfo(OrderEntity entity, OrderGrabSyncModel syncModel);

  /**
   * 构建订货单状态
   *
   * @param entity 订货单数据
   */
  void buildOrderStatus(OrderEntity entity);

  /**
   * 清除转换数据
   *
   * @param entity 待清除单据
   */
  void clearTransformInfo(OrderEntity entity);

  /**
   * 手动转换订货单
   *
   * @param ids 订货单id集合
   */
  void manualTrans(List<String> ids);

  /**
   * 通过商超数据创建订货单
   *
   * @param orderEntities 商超订货单信息
   */
  void create(List<OrderEntity> orderEntities);

  /**
   * 通过订货单ID集合获取订货单信息
   *
   * @param ids 订货单ID集合
   * @return 订货单信息
   */
  List<OrderEntity> findByIds(Set<String> ids);

  /**
   * 确认订货单
   *
   * @param ids 订货单id集合
   */
  void confirm(List<String> ids);

  /**
   * 根据参数分页查询订货单列表
   *
   * @param pageable 分页参数
   * @param dto      查询参数
   * @return 订货单列表
   */
  Page<OrderEntity> findByConditions(Pageable pageable, OrderPageDto dto);
}
