/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.order.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderEntity;
import com.biz.crm.kms.business.invoice.order.local.service.OrderService;
import com.biz.crm.kms.business.invoice.order.sdk.dto.OrderPageDto;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/order/order"})
@Api(tags={"\u8ba2\u8d27\u5355: order: \u8ba2\u8d27\u5355\u7ba1\u7406"})
public class OrderController {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Autowired
    private OrderService orderService;

    @ApiOperation(value="\u624b\u52a8\u8f6c\u6362\u8ba2\u8d27\u5355")
    @PatchMapping(value={"/manualTrans"})
    public Result manualTrans(@RequestBody List<String> ids) {
        try {
            this.orderService.manualTrans(ids);
            return Result.ok((String)"\u8f6c\u6362\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u786e\u8ba4\u8ba2\u8d27\u5355")
    @PatchMapping(value={"/confirm"})
    public Result confirm(@RequestBody List<String> ids) {
        try {
            this.orderService.confirm(ids);
            return Result.ok((String)"\u786e\u8ba4\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u8ba2\u8d27\u5355\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public Result<OrderEntity> findById(@RequestParam(value="id", required=false) @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            List<OrderEntity> list = this.orderService.findByIds(Sets.newHashSet((Object[])new String[]{id}));
            return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8ba2\u8d27\u5355\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<OrderEntity>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="OrderPageDto", value="\u5206\u9875Dto") OrderPageDto dto) {
        try {
            return Result.ok(this.orderService.findByConditions(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

