/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.order.local.service.internal;

import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductUnitVo;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderEntity;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderGoodsEntity;
import com.biz.crm.kms.business.invoice.order.local.model.OrderGrabSyncModel;
import com.biz.crm.kms.business.invoice.order.local.repository.OrderGoodsRepository;
import com.biz.crm.kms.business.invoice.order.local.service.OrderGoodsService;
import com.biz.crm.kms.business.invoice.order.sdk.enums.OrderStatus;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderGoodsService")
public class OrderGoodsServiceImpl
implements OrderGoodsService {
    private static final Logger log = LoggerFactory.getLogger(OrderGoodsServiceImpl.class);
    @Autowired
    private OrderGoodsRepository orderGoodsRepository;

    @Override
    @Transactional
    public void transform(OrderEntity entity, OrderGrabSyncModel syncModel) {
        if (CollectionUtils.isEmpty(entity.getGoodsList())) {
            entity.setOrderStatusMsg("\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e");
            return;
        }
        this.orderGoodsRepository.deleteByOrderNumber(entity.getTenantCode(), entity.getOrderNumber());
        for (OrderGoodsEntity orderGoodsEntity : entity.getGoodsList()) {
            this.clearTransformInfo(orderGoodsEntity);
            this.buildGoodsInfo(orderGoodsEntity, entity, syncModel);
        }
        this.orderGoodsRepository.saveBatch(entity.getGoodsList());
    }

    @Override
    public void buildGoodsInfo(OrderGoodsEntity orderGoodsEntity, OrderEntity entity, OrderGrabSyncModel syncModel) {
        orderGoodsEntity.setOrderStatus(OrderStatus.S100.getDictCode());
        List<Object> productList = syncModel.getDirectProductMap().get(String.format("%s-%s", orderGoodsEntity.getDirectCode(), orderGoodsEntity.getKaGoodsCode()));
        orderGoodsEntity.setId(null);
        if (CollectionUtils.isEmpty(productList)) {
            orderGoodsEntity.setOrderStatusMsg("\u672a\u5339\u914d\u5230\u4e0e\u4f01\u4e1a\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
            return;
        }
        if (CollectionUtils.isEmpty(productList = productList.stream().filter(dpv -> dpv.getSellPartyCode().equals(entity.getSoldToPartyCode())).collect(Collectors.toList()))) {
            orderGoodsEntity.setOrderStatusMsg(String.format("\u552e\u8fbe\u65b9[%s]\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb", entity.getSoldToPartyCode()));
            return;
        }
        if (productList.size() > 1) {
            orderGoodsEntity.setOrderStatusMsg("\u4f01\u4e1a\u5546\u54c1\u5b58\u5728\u591a\u4e2a\u5bf9\u5e94\u5173\u7cfb");
            return;
        }
        DirectProductVo directProductVo = (DirectProductVo)productList.get(0);
        orderGoodsEntity.setGoodsCode(directProductVo.getProductCode());
        orderGoodsEntity.setGoodsName(directProductVo.getProductName());
        if (Objects.isNull(orderGoodsEntity.getCurUnitOrderQuantity())) {
            orderGoodsEntity.setOrderStatusMsg("\u5546\u8d85\u5546\u54c1\u6570\u91cf\u9519\u8bef");
            return;
        }
        if (StringUtils.isBlank((CharSequence)orderGoodsEntity.getCurUnit())) {
            orderGoodsEntity.setOrderStatus(OrderStatus.S200.getDictCode());
            orderGoodsEntity.setCurCompanyUnitOrderQuantity(orderGoodsEntity.getCurUnitOrderQuantity());
            return;
        }
        List unitList = directProductVo.getUnitList();
        if (CollectionUtils.isEmpty((Collection)unitList)) {
            orderGoodsEntity.setOrderStatusMsg("\u672a\u5339\u914d\u4f01\u4e1a\u5546\u54c1\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb");
            return;
        }
        if (CollectionUtils.isEmpty(unitList = unitList.stream().filter(vo -> Objects.equals(vo.getKaUnitCode(), orderGoodsEntity.getCurUnit()) && Objects.nonNull(vo.getKaUnitQuantity()) && Objects.nonNull(vo.getUnitQuantity())).collect(Collectors.toList()))) {
            orderGoodsEntity.setOrderStatusMsg("\u672a\u5339\u914d\u4f01\u4e1a\u5546\u54c1\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb");
            return;
        }
        if (unitList.size() > 1) {
            orderGoodsEntity.setOrderStatusMsg("\u4f01\u4e1a\u5546\u54c1\u5b58\u5728\u591a\u4e2a\u5bf9\u5e94\u5173\u7cfb");
            return;
        }
        DirectProductUnitVo unitVo = (DirectProductUnitVo)unitList.get(0);
        BigDecimal curCompanyUnitOrderQuantity = unitVo.getUnitQuantity().multiply(orderGoodsEntity.getCurUnitOrderQuantity()).divide(unitVo.getKaUnitQuantity(), 6, 4);
        orderGoodsEntity.setCurCompanyUnitOrderQuantity(curCompanyUnitOrderQuantity);
        orderGoodsEntity.setCurCompanyUnit(unitVo.getUnitCode());
        orderGoodsEntity.setOrderStatus(OrderStatus.S200.getDictCode());
    }

    @Override
    public void clearTransformInfo(OrderGoodsEntity entity) {
        entity.setGoodsCode(null);
        entity.setGoodsName(null);
        entity.setCurCompanyUnitOrderQuantity(null);
        entity.setCurCompanyUnit(null);
        entity.setSoldToPartyName(null);
        entity.setSoldToPartyCode(null);
    }
}

