package com.biz.crm.kms.business.invoice.order.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 订货单分页查询dto
 *
 * @author ning.zhang
 * @date 2022/11/2
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OrderPageDto", description = "订货单分页查询dto")
public class OrderPageDto extends TenantFlagOpDto {

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 抓单生成的订单编号
   */
  @ApiModelProperty("抓单生成的订单编号")
  private String orderNumber;

  /**
   * 商超订单编号
   */
  @ApiModelProperty("商超订单编号")
  private String kaOrderNumber;

  /**
   * 订单当前状态
   *
   * @see com.biz.crm.kms.business.invoice.order.sdk.enums.OrderStatus
   */
  @ApiModelProperty("订单当前状态")
  private String orderStatus;

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String kaCode;

  /**
   * 商超名称
   */
  @ApiModelProperty("商超名称")
  private String kaName;

  /**
   * 订单日期
   */
  @ApiModelProperty("订单日期")
  private String orderDate;

  /**
   * 交货日期
   */
  @ApiModelProperty("交货日期")
  private String deliveryDate;

  /**
   * 商超门店/大仓编号
   */
  @ApiModelProperty("商超门店/大仓编号")
  private String kaStoreCode;

  /**
   * 商超门店/大仓名称
   */
  @ApiModelProperty("商超门店/大仓名称")
  private String kaStoreName;

  /**
   * 企业门店/大仓编号
   */
  @ApiModelProperty("企业门店/大仓编号")
  private String storeCode;

  /**
   * 企业门店/大仓名称
   */
  @ApiModelProperty("企业门店/大仓名称")
  private String storeName;

}
