package com.biz.crm.kms.business.audit.match.feign.feign;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.feign.feign.internal.InvoiceSalesDataVoFeignImpl;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 *
 * @author hd
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-kms}",
        path = "crm-kms",
        fallbackFactory = InvoiceSalesDataVoFeignImpl.class)
public interface InvoiceSalesDataVoFeign {

    /**
     * 条件查询参数
     *
     * @param dto
     * @return
     */
    @ApiOperation("条件查询参数")
    @PostMapping("/v1/salesData/salesData/findData")
    Result<SalesDataVo> findData(@RequestBody QueryConditionDto dto);
}
