package com.biz.crm.kms.business.audit.match.feign.service.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.feign.feign.InvoiceSalesDataVoFeign;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;


/**
 * @Class InvoiceSalesDataVoServiceImpl
 * @Description
 * @Author : ZS
 * @Date: 2022/11/16  10:56
 */
@Service
@Slf4j
public class InvoiceSalesDataVoServiceImpl implements InvoiceSalesDataVoService {

    @Autowired
    private InvoiceSalesDataVoFeign invoiceSalesDataVoFeign;


    @Override
    public SalesDataVo findByCondition(QueryConditionDto dto) {
        if (ObjectUtils.isEmpty(dto)){
            return new SalesDataVo();
        }
        Result<SalesDataVo> result = invoiceSalesDataVoFeign.findData(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }
}
