package com.biz.crm.kms.business.invoice.sales.data.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataGrabsService;
import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 销售数据: salesData: 销售数据管理
 *
 * @author ning.zhang
 * @date 2022/11/8
 */
@Slf4j
@RestController
@RequestMapping("/v1/salesData/salesData")
@Api(tags = "销售数据: salesData: 销售数据管理")
public class SalesDataController {

  @Autowired
  private SalesDataService salesDataService;

  @Autowired
  private SalesDataGrabsService salesDataGrabsService;

  @Autowired(required = false)
  private InvoiceSalesDataVoService invoiceSalesDataVoService;

  /**
   * 通过ID获取销售数据详细信息
   *
   * @param id 销售数据ID
   * @return 销售数据信息
   */
  @ApiOperation(value = "通过ID获取销售数据详细信息")
  @GetMapping("/findById")
  public Result<SalesDataEntity> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      List<SalesDataEntity> list = this.salesDataService.findByIds(Sets.newHashSet(id));
      return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动转换销售数据
   *
   * @param ids 销售数据id集合
   * @return 转换结果
   */
  @ApiOperation(value = "手动转换销售数据")
  @PatchMapping("/manualTransSaleData")
  public Result manualTransSaleData(@RequestBody List<String> ids) {
    try {
      this.salesDataService.manualTransSaleData(ids);
      return Result.ok("转换成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  /**
   * 手动同步某一天的POS销售数据(日期格式20220103)
   *
   * @param date 条件
   */
  @ApiOperation(value = "手动同步某一天的POS销售数据(日期格式20220103)")
  @GetMapping("syncPosDataByDate")
  public Result<?> syncPosDataByDate(@RequestParam("date")String date) {
    try {
      this.salesDataService.posData(date);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "手动同步沃尔玛的POS销售数据(日期格式20220103)")
  @GetMapping("getPostDataOne")
  public Result<?> getPostDataOne(@RequestParam("date")String date) {
    try {
      this.salesDataService.getPostDataOne(date);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("手动触发定时任务")
  @GetMapping("autoJob")
  public void autoJob(){
    this.salesDataGrabsService.autoNotConvertSaleData();
  }

  @ApiOperation("条件查询参数")
  @PostMapping("findData")
  public Result<SalesDataVo> findData(@RequestBody QueryConditionDto dto){
    try {
      SalesDataVo byCondition = this.invoiceSalesDataVoService.findByCondition(dto);
      return Result.ok(byCondition);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }

  }


}
