package com.biz.crm.kms.business.invoice.sales.data.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 销售数据抓取数据(python)类
 *
 * @author ning.zhang
 * @date 2022/10/31
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SalesDataGrabEntity", description = "销售数据抓取数据(python)类")
@Entity
@TableName("kms_sales_data_grab")
@Table(name = "kms_sales_data_grab", indexes = {
    @Index(name = "kms_sales_data_grab_index1", columnList = "tenant_code"),
    @Index(name = "kms_sales_data_grab_index2", columnList = "raw_data_id"),
    @Index(name = "kms_sales_data_grab_index3", columnList = "direct_code"),
    @Index(name = "kms_sales_data_grab_index4", columnList = "order_number"),
    @Index(name = "kms_sales_data_grab_index5", columnList = "ka_order_number"),
    @Index(name = "kms_sales_data_grab_index6", columnList = "version_number"),
})
@org.hibernate.annotations.Table(appliesTo = "kms_sales_data_grab", comment = "销售数据抓取数据(python)表")
public class SalesDataGrabEntity extends TenantOpEntity {

  private static final long serialVersionUID = 9020546554358620962L;

  /**
   * 原始数据ID
   */
  @ApiModelProperty("原始数据ID")
  @Column(name = "raw_data_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '原始数据ID 对应表 kms_grab_response_data 的ID'")
  private String rawDataId;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  @Column(name = "direct_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '系统编码'")
  private String directCode;

  /**
   * 抓单生成的销售数据编号
   */
  @ApiModelProperty("抓单生成的销售数据编号")
  @Column(name = "order_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '抓单生成的销售数据编号'")
  private String orderNumber;

  /**
   * 销售数据版本号
   */
  @ApiModelProperty("销售数据版本号")
  @Column(name = "version_number", length = 10, columnDefinition = "INT(10) COMMENT '销售数据版本号'")
  private Integer versionNumber;

  /**
   * 商超销售数据编号
   */
  @ApiModelProperty("商超销售数据编号")
  @Column(name = "ka_order_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超销售数据编号'")
  private String kaOrderNumber;

  /**
   * 单据来源
   */
  @ApiModelProperty("单据来源")
  @Column(name = "invoices_source", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单据来源'")
  private String invoicesSource;

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  @Column(name = "ka_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超编码'")
  private String kaCode;

  /**
   * 商超名称
   */
  @ApiModelProperty("商超名称")
  @Column(name = "ka_name", columnDefinition = "VARCHAR(255) COMMENT '商超名称'")
  private String kaName;

  /**
   * 销售日期
   */
  @ApiModelProperty("销售日期")
  @Column(name = "sales_date", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售日期'")
  private String salesDate;


  /**
   * 商超门店/大仓编号
   */
  @ApiModelProperty("商超门店/大仓编号")
  @Column(name = "ka_store_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超门店/大仓编号'")
  private String kaStoreCode;

  /**
   * 商超门店/大仓名称
   */
  @ApiModelProperty("商超门店/大仓名称")
  @Column(name = "ka_store_name", columnDefinition = "VARCHAR(255) COMMENT '商超门店/大仓名称'")
  private String kaStoreName;

  /**
   * 企业门店/大仓编号
   */
  @ApiModelProperty("企业门店/大仓编号")
  @Column(name = "store_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '企业门店/大仓编号'")
  private String storeCode;

  /**
   * 企业门店/大仓名称
   */
  @ApiModelProperty("企业门店/大仓名称")
  @Column(name = "store_name", columnDefinition = "VARCHAR(255) COMMENT '企业门店/大仓名称'")
  private String storeName;


  /**
   * 企业产品编号
   */
  @ApiModelProperty("企业产品编号")
  @Column(name = "goods_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '企业产品编号'")
  private String goodsCode;

  /**
   * 企业产品名称
   */
  @ApiModelProperty("企业产品名称")
  @Column(name = "goods_name", columnDefinition = "VARCHAR(255) COMMENT '企业产品名称'")
  private String goodsName;

  /**
   * 商超产品编号
   */
  @ApiModelProperty("商超产品编号")
  @Column(name = "ka_goods_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超产品编号'")
  private String kaGoodsCode;

  /**
   * 商超产品名称
   */
  @ApiModelProperty("商超产品名称")
  @Column(name = "ka_goods_name", columnDefinition = "VARCHAR(255) COMMENT '商超产品名称'")
  private String kaGoodsName;

  /**
   * 产品国际条码
   */
  @ApiModelProperty("产品国际条码")
  @Column(name = "goods_bar_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品国际条码'")
  private String goodsBarCode;

  /**
   * 产品规格
   */
  @ApiModelProperty("产品规格")
  @Column(name = "specification", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品规格'")
  private String specification;

  /**
   * 销售成本
   */
  @ApiModelProperty("销售成本")
  @Column(name = "sales_cost", columnDefinition = "DECIMAL(20,4) COMMENT '销售成本'")
  private BigDecimal salesCost;

  /**
   * 销售成本(不含税)
   */
  @ApiModelProperty("销售成本(不含税)")
  @Column(name = "sales_cost_not", columnDefinition = "DECIMAL(20,4) COMMENT '销售成本(不含税)'")
  private BigDecimal salesCostNot;

  /**
   * 销售金额
   */
  @ApiModelProperty("销售金额")
  @Column(name = "sales_amount", columnDefinition = "DECIMAL(20,4) COMMENT '销售金额'")
  private BigDecimal salesAmount;

  /**
   * 销售金额(不含税)
   */
  @ApiModelProperty("销售金额(不含税)")
  @Column(name = "sales_amount_noTax", columnDefinition = "DECIMAL(20,4) COMMENT '销售金额不含税'")
  private BigDecimal salesAmountNoTax;

  /**
   * 促销扣款
   */
  @ApiModelProperty("促销扣款")
  @Column(name = "promotion_deduction", columnDefinition = "DECIMAL(20,4) COMMENT '促销扣款'")
  private BigDecimal PromotionDeduction;

  /**
   * 促销金额
   */
  @ApiModelProperty("促销金额")
  @Column(name = "promotion_amount", columnDefinition = "DECIMAL(20,4) COMMENT '促销金额'")
  private BigDecimal PromotionAmount;

  /**
   * 优惠券金额
   */
  @ApiModelProperty("优惠券金额")
  @Column(name = "coupon_amount", columnDefinition = "DECIMAL(20,4) COMMENT '优惠券金额'")
  private BigDecimal couponAmount;

  /**
   * 经营方式
   */
  @ApiModelProperty("经营方式")
  @Column(name = "run_mode", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经营方式'")
  private String runMode;

  /**
   * 转换状态
   *
   * @see GrabTransStatus
   */
  @ApiModelProperty("转换状态")
  @Column(name = "trans_status", length = 32, columnDefinition = "VARCHAR(32) DEFAULT '0' COMMENT '转换状态'")
  private String transStatus;

  /**
   * 区域编码
   */
  @ApiModelProperty("区域编码")
  @Column(name = "area_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '区域编码'")
  private String areaCode;

  /**
   * 区域名称
   */
  @ApiModelProperty("区域名称")
  @Column(name = "area_name", columnDefinition = "VARCHAR(255) COMMENT '区域名称'")
  private String areaName;

  /**
   * 竞品品牌
   */
  @ApiModelProperty("竞品品牌")
  @Column(name = "competitive_brands", length = 64, columnDefinition = "VARCHAR(64) COMMENT '竞品品牌'")
  private String competitiveBrands;

  /**
   * 当前单位层级
   */
  @ApiModelProperty("当前单位层级")
  @Column(name = "cur_unit_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT '当前单位层级'")
  private String curUnitLevel;

  /**
   * 商超当前单位
   */
  @ApiModelProperty("商超当前单位")
  @Column(name = "cur_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超当前单位'")
  private String curUnit;

  /**
   * 商超当前单位销售数量
   */
  @ApiModelProperty("商超当前单位销售数量")
  @Column(name = "cur_unit_sales_quantity", columnDefinition = "DECIMAL(20,4) COMMENT '商超当前单位销售数量'")
  private BigDecimal curUnitSalesQuantity;

  /**
   * 最小单位层级
   */
  @ApiModelProperty("最小单位层级")
  @Column(name = "min_unit_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT '最小单位层级'")
  private String minUnitLevel;

  /**
   * 最小单位
   */
  @ApiModelProperty("最小单位")
  @Column(name = "min_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '最小单位'")
  private String minUnit;

  /**
   * 最小单位销售数量
   */
  @ApiModelProperty("最小单位销售数量")
  @Column(name = "min_unit_sales_quantity", columnDefinition = "DECIMAL(20,4) COMMENT '最小单位销售数量'")
  private BigDecimal minUnitSalesQuantity;

  /**
   * 最大单位层级
   */
  @ApiModelProperty("最大单位层级")
  @Column(name = "max_unit_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT '最大单位层级'")
  private String maxUnitLevel;

  /**
   * 最小单位
   */
  @ApiModelProperty("最大单位")
  @Column(name = "max_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '最大单位'")
  private String maxUnit;

  /**
   * 最大单位销售数量
   */
  @ApiModelProperty("最大单位销售数量")
  @Column(name = "max_unit_sales_quantity", columnDefinition = "DECIMAL(20,4) COMMENT '最大单位销售数量'")
  private BigDecimal maxUnitSalesQuantity;

  /**
   * 业务区域
   */
  @ApiModelProperty("业务区域")
  @Column(name = "business_area", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务区域'")
  private String businessArea;

  /**
   * 登录账号
   */
  @ApiModelProperty("登录账号")
  @Column(name = "user_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '登录账号'")
  private String userName;

  /**
   * 城市编码
   */
  @ApiModelProperty("城市编码")
  @Column(name = "city_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '城市编码'")
  private String cityCode;

  /**
   * 城市名称
   */
  @ApiModelProperty("城市名称")
  @Column(name = "city_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '城市名称'")
  private String cityName;

  /**
   * 渠道编码
   */
  @ApiModelProperty("渠道编码")
  @Column(name = "channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
  private String channelCode;

  /**
   * 渠道名称
   */
  @ApiModelProperty("渠道名称")
  @Column(name = "channel_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '渠道名称'")
  private String channelName;

  /**
   * 小类编码
   */
  @ApiModelProperty("小类编码")
  @Column(name = "sub_class_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '小类编码'")
  private String subClassCode;

  /**
   * 小类名称
   */
  @ApiModelProperty("小类名称")
  @Column(name = "sub_class_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '小类名称'")
  private String subClassName;

  /**
   * 供应商编码
   */
  @ApiModelProperty("供应商编码")
  @Column(name = "supply_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码'")
  private String supplyCode;

  /**
   * 供应商名称
   */
  @ApiModelProperty("供应商名称")
  @Column(name = "supply_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商名称'")
  private String supplyName;
}