package com.biz.crm.kms.business.invoice.sales.data.local.imports.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;


/**
 * @Class InvoiceSalesImportsVo
 * @Description 单据-销售数据导入模板
 * @Author : CYJ
 * @Date: 2022/11/28  15:12
 */
@Data
@CrmExcelImport(startRow = 2)
public class InvoiceSalesImportsVo extends CrmExcelVo {

    /**
     * KMS销售数据单号
     */
    @CrmExcelColumn("KMS销售数据单号")
    private String orderNumber;

    /**
     * 系统编码
     */
    @CrmExcelColumn("*系统编码")
    private String directCode;

    /**
     * 系统名称
     */
    @CrmExcelColumn("*系统名称")
    private String kaName;


    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn("*业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @CrmExcelColumn("*业务单元")
    private String businessUnitCode;

    /**
     * 售达方编码
     */
    @CrmExcelColumn("*售达方编码")
    private String soldToPartyCode;

    /**
     * 售达方名称
     */
    @CrmExcelColumn("*售达方名称")
    private String soldToPartyName;

    /**
     * 送达方编码
     */
    @CrmExcelColumn("*送达方编码")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @CrmExcelColumn("*送达方名称")
    private String deliveryPartyName;

    /**
     * 商超门店/大仓编号
     */
    @CrmExcelColumn("*零售商门店编号")
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @CrmExcelColumn("*零售商门店名称")
    private String kaStoreName;

    /**
     * 零售商区域编码
     */
    @CrmExcelColumn("零售商区域编码")
    private String areaCode;

    /**
     * 零售商区域名称
     */
    @CrmExcelColumn("零售商区域名称")
    private String areaName;

    /**
     * 业务区域
     */
    @CrmExcelColumn("业务区域")
    private String businessArea;

    /**
     * 产品编号
     */
    @CrmExcelColumn("*产品编号")
    private String goodsCode;

    /**
     * 企业产品名称
     */
    @CrmExcelColumn("*产品名称")
    private String goodsName;

    /**
     * 企业当前单位
     */
    @CrmExcelColumn("*当前单位")
    private String curCompanyUnit;

    /**
     * 企业单位数量
     */
    @CrmExcelColumn("*当前数量")
    private String curCompanyUnitOrderQuantityStr;


    /**
     * 零售商产品编号
     */
    @CrmExcelColumn("*零售商产品编号")
    private String kaGoodsCode;

    /**
     * 零售商产品名称
     */
    @CrmExcelColumn("*零售商产品名称")
    private String kaGoodsName;

    /**
     * 商超当前单位
     */
    @CrmExcelColumn("零售商产品单位")
    private String curUnit;

    /**
     * 商超当前单位销售数量
     */
    @CrmExcelColumn("*零售商产品数量")
    private String curUnitSalesQuantityStr;

    /**
     * 销售成本(不含税)
     */
    @CrmExcelColumn("*销售成本(含税)")
    private String salesCostStr;

    /**
     * 销售成本(不含税)
     */
    @CrmExcelColumn("*销售成本(不含税)")
    private String salesCostNotStr;

    /**
     * 销售金额(不含税)
     */
    @CrmExcelColumn("*销售金额(不含税)")
    private String salesAmountNoTaxStr;

    /**
     * 销售金额(含税)
     */
    @CrmExcelColumn("*销售金额(含税)")
    private String salesAmountStr;

    /**
     * 销售日期
     */
    @CrmExcelColumn("*销售日期")
    private String salesDate;

    /**
     * 收货金额
     */
    @CrmExcelColumn("*收货金额")
    private String receiptAmountStr;

    /**
     * 促销扣款
     */
    @CrmExcelColumn("*促销扣款")
    private String PromotionDeductionStr;

    /**
     * 促销金额
     */
    @CrmExcelColumn("*促销金额")
    private String PromotionAmountStr;

    /**
     * 优惠券金额
     */
    @CrmExcelColumn("*优惠券金额")
    private String couponAmountStr;

}
