package com.biz.crm.kms.business.invoice.sales.data.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataGrabEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.model.SalesDataGrabConditionModel;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 销售数据抓取数据(python)表的mybatis-plus接口类 {@link SalesDataGrabEntity}
 *
 * @author ning.zhang
 * @date 2022-11-08 10:03:03
 */
public interface SalesDataGrabMapper extends BaseMapper<SalesDataGrabEntity> {

  /**
   * 多条件查询销售数据抓取数据列表
   *
   * @param model 条件model
   * @return 销售数据抓取数据列表
   */
  List<SalesDataGrabEntity> findBySalesDataGrabConditionModel(@Param("model") SalesDataGrabConditionModel model);


  /**
   * 验收单根据租户编码和转换状态查询验收单带商品
   *
   * @param page            分页信息
   * @param tenantCode      租户好
   * @param transStatusList 单据状态
   * @return
   */
  Page<String> findSaleDataGrabPage(Page<String> page, @Param("tenantCode") String tenantCode, @Param("transStatusList") List<String> transStatusList,@Param("dateTime")String day);

}

