package com.biz.crm.kms.business.invoice.sales.data.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.model.SalesDataConditionModel;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**
 * 销售数据表的mybatis-plus接口类 {@link SalesDataEntity}
 *
 * @author ning.zhang
 * @date 2022-11-08 10:03:09
 */
public interface SalesDataMapper extends BaseMapper<SalesDataEntity> {

  /**
   * 多条件查询销售数据规则列表
   *
   * @param model 条件model
   * @return 销售数据规则列表
   */
  List<SalesDataEntity> findBySalesDataConditionModel(@Param("model") SalesDataConditionModel model);

  void batchSave(@Param("list") Collection<SalesDataEntity> entities);

  SalesDataVo findCondition(@Param("dto")QueryConditionDto dto);
}

