package com.biz.crm.kms.business.invoice.sales.data.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 销售数据多条件查询model
 *
 * @author ning.zhang
 * @date 2022/10/25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SalesDataConditionModel", description = "销售数据多条件查询model")
public class SalesDataConditionModel {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /**
   * 销售数据ID集合
   */
  @ApiModelProperty("销售数据ID集合")
  private Set<String> ids;
}
