package com.biz.crm.kms.business.invoice.sales.data.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataGrabEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.mapper.SalesDataGrabMapper;
import com.biz.crm.kms.business.invoice.sales.data.local.model.SalesDataGrabConditionModel;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * 销售数据抓取数据(python)表的数据库访问类 {@link SalesDataGrabEntity}
 *
 * @author ning.zhang
 * @date 2022-11-08 10:03:06
 */
@Component
public class SalesDataGrabRepository extends ServiceImpl<SalesDataGrabMapper, SalesDataGrabEntity> {


  /**
   * 根据企业验收单编号集合获取待转换记录
   *
   * @return
   */
  public List<SalesDataGrabEntity> findByOrderNumbers(String tenantCode, List<String> orderNumbers) {
    return this.lambdaQuery()
            .eq(SalesDataGrabEntity::getTenantCode, tenantCode)
            .in(SalesDataGrabEntity::getOrderNumber, orderNumbers)
            .list();
  }
  /**
   * 多条件查询销售数据抓取数据列表
   *
   * @param model 条件model
   * @return 销售数据抓取数据列表
   */
  public List<SalesDataGrabEntity> findBySalesDataGrabConditionModel(SalesDataGrabConditionModel model) {
    return this.baseMapper.findBySalesDataGrabConditionModel(model);
  }


  /**
   * 验收单根据租户编码和转换状态查询验收单带商品
   *
   * @param pageable
   * @param tenantCode
   * @param transStatusList
   * @return
   */
  public Page<String> findSaleDataGrabPage(Pageable pageable, String tenantCode, List<String> transStatusList,String day) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
    Page<String> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findSaleDataGrabPage(page, tenantCode, transStatusList,day);
  }

  /**
   * 根据验收单号更新转换状态
   *
   * @param tenantCode      租户编码
   * @param transStatus     转换状态
   * @param orderNumberList 验收单号
   */
  public void updateTransStatusByOrderNumberList(String tenantCode, GrabTransStatus transStatus, List<String> orderNumberList) {
    if (StringUtils.isBlank(tenantCode)
            || Objects.isNull(transStatus)
            || CollectionUtil.isEmpty(orderNumberList)) {
      return;
    }
    this.lambdaUpdate()
            .eq(SalesDataGrabEntity::getTenantCode, tenantCode)
            .in(SalesDataGrabEntity::getOrderNumber, orderNumberList)
            .set(SalesDataGrabEntity::getTransStatus, transStatus.getDictCode())
            .update();
  }
}
