package com.biz.crm.kms.business.invoice.sales.data.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.mapper.SalesDataMapper;
import com.biz.crm.kms.business.invoice.sales.data.local.model.SalesDataConditionModel;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 销售数据表的数据库访问类 {@link SalesDataEntity}
 *
 * @author ning.zhang
 * @date 2022-11-08 10:03:12
 */
@Component
public class SalesDataRepository extends ServiceImpl<SalesDataMapper, SalesDataEntity> {

  @Autowired(required = false)
  private SalesDataMapper salesDataMapper;
  /**
   * 根据销售数据编码删除数据
   *
   * @param tenantCode 租户编码
   * @param orderNumber 销售数据编码
   */
  public void deleteByOrderNumber(String tenantCode, String orderNumber) {
    this.lambdaUpdate()
        .eq(SalesDataEntity::getTenantCode, tenantCode)
        .eq(SalesDataEntity::getOrderNumber, orderNumber)
        .remove();
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<SalesDataEntity> findByIds(List<String> ids) {
    return this.lambdaQuery()
            .in(SalesDataEntity::getId, ids)
            .list();
  }

  /**
   * 根据销售数据编码获取销售数据信息
   *
   * @param tenantCode 租户编码
   * @param orderNumber 销售数据编码
   * @return 销售数据信息
   */
  public SalesDataEntity findByOrderNumber(String tenantCode, String orderNumber) {
    return this.lambdaQuery()
        .eq(SalesDataEntity::getTenantCode, tenantCode)
        .eq(SalesDataEntity::getOrderNumber, orderNumber)
        .one();
  }

  /**
   * 根据验收单编码查询验收单
   *
   * @param tenantCode
   * @param orderNumberList
   * @return
   */
  public List<SalesDataEntity> findByOrderNumberList(String tenantCode, List<String> orderNumberList) {
    return this.lambdaQuery()
            .eq(SalesDataEntity::getTenantCode, tenantCode)
            .in(SalesDataEntity::getOrderNumber, orderNumberList)
            .list();
  }

  /**
   * 多条件查询销售数据规则列表
   *
   * @param model 条件model
   * @return 销售数据规则列表
   */
  public List<SalesDataEntity> findBySalesDataConditionModel(SalesDataConditionModel model) {
    return this.baseMapper.findBySalesDataConditionModel(model);
  }

  /**
   * 根据条件查询数据
   * @param orderNumber
   * @param kaGoodsCode
   * @param kaStoreCode
   * @param salesDate
   * @return
   */
  public SalesDataEntity findByCondition(String orderNumber,String kaGoodsCode,String kaStoreCode,String salesDate){
    return this.lambdaQuery().eq(SalesDataEntity::getTenantCode, TenantUtils.getTenantCode())
            .eq(SalesDataEntity::getSalesDate,salesDate)
            .eq(SalesDataEntity::getOrderNumber,orderNumber)
            .eq(SalesDataEntity::getKaGoodsCode,kaGoodsCode)
            .eq(SalesDataEntity::getKaStoreCode,kaStoreCode)
            .one();
  }



  /**
   * 通过费用单号查找数据
   * @param orderNumbers
   * @return
   */
  public List<SalesDataEntity> findByOrderNumbers(Set<String> orderNumbers){
    if (CollectionUtils.isEmpty(orderNumbers)){
      return new ArrayList<>();
    }
    return this.lambdaQuery()
            .in(SalesDataEntity::getOrderNumber,orderNumbers)
            .list();
  }

  public SalesDataVo findCondition(QueryConditionDto dto) {
    return salesDataMapper.findCondition(dto);
  }
}
