package com.biz.crm.kms.business.invoice.sales.data.local.service;

import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;

import java.util.List;

/**
 * 销售数据抓取数据(python)表服务接口
 *
 * @author cyj
 * @date 2022-11-25 16:03:07
 */
public interface SalesDataGrabsService {

  /**
   * 根据单据号 转换单据信息
   *
   * @param orderNumberList 单据号
   * @return void
   * @author: huxmld
   * @version: v1.0.0
   * @date: 2022年12月15日 16:56:34
   */
  void manualSwitch(List<String> orderNumberList);

  /**
   * 费用单未转换单据自动解析定时任务
   */
  void autoNotConvertSaleData();

  /**
   * 费用单转换失败单据自动解析定时任务
   */
  void autoFailConvertSaleData();


  /**
   * 费用单商超门店和商超产品转换
   *
   * @param entityList
   * @return void
   * @author: zs
   * @version: v1.0.0
   * @date: 2022年12月15日 15:15:06
   */
  void convertOrder(List<SalesDataEntity> entityList);

  /**
   * 过滤正在转换的费用单号
   *
   * @param orderNumberList 费用单号集合
   * @return void
   * @author: zs
   * @version: v1.0.0
   * @date: 2022年12月15日 15:15:01
   */
  void filterSwitchIngOrderNumberList(List<String> orderNumberList);
}
