package com.biz.crm.kms.business.invoice.sales.data.local.service;

import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.model.SalesDataGrabSyncModel;

import java.util.List;
import java.util.Set;

/**
 * 销售数据表服务接口
 *
 * @author ning.zhang
 * @date 2022-11-08 10:03:13
 */
public interface SalesDataService {


  /**
   * 通过商超数据创建销售数据
   *
   * @param orderEntities 商超销售数据信息
   */
  void create(List<SalesDataEntity> orderEntities);

  /**
   * 通过销售数据ID集合获取销售数据信息
   *
   * @param ids 销售数据ID集合
   * @return 销售数据信息
   */
  List<SalesDataEntity> findByIds(Set<String> ids);


  /**
   * 手动转换销售数据
   *
   * @param ids 销售数据id集合
   */
  void manualTransSaleData(List<String> ids);

  /**
   * 每天晚上11点同步数据中台的POS销售单
   */
  void syncPosData();

  /**
   * 手动拉取Pos数据
   * @param date
   */
  void posData(String date);

  void getPostDataOne(String date);
}
