package com.biz.crm.kms.business.invoice.sales.data.local.service.internal;

import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataGrabsService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 销售数据抓取数据(python)后自动转换     job
 *
 * @author: zs
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class InvoiceSaleDataAutoJob {


    @Autowired(required = false)
    private SalesDataGrabsService salesDataGrabsService;


    /**
     * 销售数据未转换单据自动转换定时任务
     */
    @DynamicTaskService(cornExpression = "0 0 1/2 * * ?", taskDesc = "销售数据未转换单据自动转换定时任务")
    public void autoNotConvertAcceptanceOrder() {
        //TODO  需要改成  定时任务分片+redis锁
        salesDataGrabsService.autoNotConvertSaleData();
    }
    /**
     * 销售数据转换失败单据自动转换定时任务
     */
    @DynamicTaskService(cornExpression = "0 0 2/2 * * ?", taskDesc = "销售数据转换失败单据自动转换定时任务")
    public void autoFailConvertAcceptanceOrder() {
        //TODO  需要改成  定时任务分片+redis锁
        salesDataGrabsService.autoFailConvertSaleData();
    }

}
