package com.biz.crm.kms.business.invoice.sales.data.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.repository.SalesDataRepository;
import com.biz.crm.kms.business.invoice.sales.data.local.service.InvoiceSalesDataImportsService;
import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataLogEventDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.event.SalesDataLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @Class InvoiceSalesDataImportsServiceImpl
 * @Description
 * @Author : CYJ
 * @Date: 2022/11/28  16:24
 */
@Service("invoiceSalesDataImportsService")
@Slf4j
public class InvoiceSalesDataImportsServiceImpl implements InvoiceSalesDataImportsService {

    @Autowired
    private SalesDataService salesDataService;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private SalesDataRepository salesDataRepository;

    /**
     * 导入新增
     * @param list
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void importsCreate(List<SalesDataEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(aa ->{
            SalesDataEntity entity = this.salesDataRepository.findByOrderNumber(TenantUtils.getTenantCode(),aa.getOrderNumber());
            Validate.isTrue(ObjectUtils.isEmpty(entity),"存在该POS数据");
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
            //数据来源说明
            aa.setInvoicesSource("手动导入");
        });
        this.salesDataService.create(list);
        Collection<SalesDataDto> invoiceStatementDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list,SalesDataEntity.class,SalesDataDto.class, LinkedHashSet.class, ArrayList.class);
        // 业务日志创建
        invoiceStatementDtos.forEach(dto -> {
            SalesDataLogEventDto logEventDto = new SalesDataLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<SalesDataLogEventListener, SalesDataLogEventDto> onCreate =
                    SalesDataLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, SalesDataLogEventListener.class, onCreate);
        });
    }
}
