package com.biz.crm.kms.business.invoice.sales.data.local.service.internal;

import com.biz.crm.kms.business.invoice.sales.data.local.repository.SalesDataRepository;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hd
 */
@Slf4j
@Service("invoiceSalesDataVoService")
public class InvoiceSalesDataVoServiceImpl implements InvoiceSalesDataVoService {

    @Autowired(required = false)
    private SalesDataRepository salesDataRepository;

    @Override
    public SalesDataVo findByCondition(QueryConditionDto dto) {
        if (ObjectUtils.isEmpty(dto)) {
            return new SalesDataVo();
        }
        if (StringUtils.isEmpty(dto.getEndTimeOrDate()) || StringUtils.isEmpty(dto.getStartTimeOrDate())
                || StringUtils.isEmpty(dto.getGoodsCode()) || StringUtils.isEmpty(dto.getDeliveryPartyCode())) {
            return new SalesDataVo();
        }
        return salesDataRepository.findCondition(dto);
    }
}
