/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.sales.data.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataGrabsService;
import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/salesData/salesData"})
@Api(tags={"\u9500\u552e\u6570\u636e: salesData: \u9500\u552e\u6570\u636e\u7ba1\u7406"})
public class SalesDataController {
    private static final Logger log = LoggerFactory.getLogger(SalesDataController.class);
    @Autowired
    private SalesDataService salesDataService;
    @Autowired
    private SalesDataGrabsService salesDataGrabsService;
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;

    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u9500\u552e\u6570\u636e\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public Result<SalesDataEntity> findById(@RequestParam(value="id", required=false) @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            List<SalesDataEntity> list = this.salesDataService.findByIds(Sets.newHashSet((Object[])new String[]{id}));
            return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u8f6c\u6362\u9500\u552e\u6570\u636e")
    @PatchMapping(value={"/manualTransSaleData"})
    public Result manualTransSaleData(@RequestBody List<String> ids) {
        try {
            this.salesDataService.manualTransSaleData(ids);
            return Result.ok((String)"\u8f6c\u6362\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u540c\u6b65\u67d0\u4e00\u5929\u7684POS\u9500\u552e\u6570\u636e(\u65e5\u671f\u683c\u5f0f20220103)")
    @GetMapping(value={"syncPosDataByDate"})
    public Result<?> syncPosDataByDate(@RequestParam(value="date") String date) {
        try {
            this.salesDataService.posData(date);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u540c\u6b65\u6c83\u5c14\u739b\u7684POS\u9500\u552e\u6570\u636e(\u65e5\u671f\u683c\u5f0f20220103)")
    @GetMapping(value={"getPostDataOne"})
    public Result<?> getPostDataOne(@RequestParam(value="date") String date) {
        try {
            this.salesDataService.getPostDataOne(date);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1")
    @GetMapping(value={"autoJob"})
    public void autoJob() {
        this.salesDataGrabsService.autoNotConvertSaleData();
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u53c2\u6570")
    @PostMapping(value={"findData"})
    public Result<SalesDataVo> findData(@RequestBody QueryConditionDto dto) {
        try {
            SalesDataVo byCondition = this.invoiceSalesDataVoService.findByCondition(dto);
            return Result.ok((Object)byCondition);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

