/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.sales.data.local.imports.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.imports.model.InvoiceSalesImportsVo;
import com.biz.crm.kms.business.invoice.sales.data.local.service.InvoiceSalesDataImportsService;
import com.biz.crm.kms.business.invoice.sales.data.local.util.DictValueUtil;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceSalesDataImportsProcess
implements ImportProcess<InvoiceSalesImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceSalesDataImportsProcess.class);
    @Autowired
    private InvoiceSalesDataImportsService importsService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, InvoiceSalesImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.info("\u5bfc\u5165\u6570\u636e\u6570\u636e{}", data);
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SalesDataEntity> importList = this.validate(data);
        log.info("\u4fdd\u5b58\u6570\u636eLOG\uff1a{}", importList);
        this.importsService.importsCreate(importList);
        return null;
    }

    private List<SalesDataEntity> validate(LinkedHashMap<Integer, InvoiceSalesImportsVo> data) {
        ArrayList<InvoiceSalesImportsVo> invoiceStatementImportsVos = new ArrayList<InvoiceSalesImportsVo>(data.values());
        Set orderNumberList = invoiceStatementImportsVos.stream().map(InvoiceSalesImportsVo::getOrderNumber).collect(Collectors.toSet());
        Validate.isTrue((boolean)Objects.equals(invoiceStatementImportsVos.size(), orderNumberList.size()), (String)"\u9500\u552e\u5355\u53f7\u6709\u91cd\u590d", (Object[])new Object[0]);
        ArrayList<SalesDataEntity> salesDataEntities = new ArrayList<SalesDataEntity>();
        invoiceStatementImportsVos.forEach(importsVo -> {
            log.info("\u6570\u636e\u5c55\u793a", (Object)importsVo);
            SalesDataEntity entity = (SalesDataEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)importsVo, SalesDataEntity.class, HashSet.class, ArrayList.class, new String[0])));
            this.amountTrans((InvoiceSalesImportsVo)((Object)importsVo), entity);
            salesDataEntities.add(entity);
        });
        if (CollectionUtils.isEmpty(salesDataEntities)) {
            return new ArrayList<SalesDataEntity>();
        }
        this.adjustData(salesDataEntities);
        return salesDataEntities;
    }

    public void amountTrans(InvoiceSalesImportsVo vo, SalesDataEntity entity) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getOrderNumber()), (String)"KMS\u9500\u552e\u6570\u636e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getDirectCode()), (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaName()), (String)"\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getBusinessFormatCode()), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSoldToPartyCode()), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSoldToPartyName()), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getDeliveryPartyCode()), (String)"\u9001\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getDeliveryPartyName()), (String)"\u9001\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaStoreCode()), (String)"\u96f6\u552e\u5546\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaStoreName()), (String)"\u96f6\u552e\u5546\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaGoodsCode()), (String)"\u96f6\u552e\u5546\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getKaGoodsName()), (String)"\u96f6\u552e\u5546\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getGoodsCode()), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getGoodsName()), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCurCompanyUnit()), (String)"\u5f53\u524d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCurCompanyUnitOrderQuantityStr()), (String)"\u5f53\u524d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCurUnitSalesQuantityStr()), (String)"\u96f6\u552e\u5546\u4ea7\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSalesAmountNoTaxStr()), (String)"\u9500\u552e\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSalesAmountStr()), (String)"\u9500\u552e\u91d1\u989d(\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSalesDate()), (String)"\u9500\u552e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getReceiptAmountStr()), (String)"\u6536\u8d27\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getPromotionDeductionStr()), (String)"\u4fc3\u9500\u6263\u6b3e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getPromotionAmountStr()), (String)"\u4fc3\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCouponAmountStr()), (String)"\u4f18\u60e0\u5238\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)vo.getCurCompanyUnitOrderQuantityStr())) {
            BigDecimal curCompanyUnitOrderQuantity = new BigDecimal(vo.getCurCompanyUnitOrderQuantityStr());
            entity.setCurCompanyUnitOrderQuantity(curCompanyUnitOrderQuantity);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getCurUnitSalesQuantityStr())) {
            BigDecimal curUnitSalesQuantity = new BigDecimal(vo.getCurUnitSalesQuantityStr());
            entity.setCurUnitSalesQuantity(curUnitSalesQuantity);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getSalesCostStr())) {
            BigDecimal salesCost = new BigDecimal(vo.getSalesCostStr());
            entity.setSalesCost(salesCost);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getSalesCostNotStr())) {
            BigDecimal salesCostNot = new BigDecimal(vo.getSalesCostNotStr());
            entity.setSalesCostNot(salesCostNot);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getSalesAmountNoTaxStr())) {
            BigDecimal salesAmountNoTax = new BigDecimal(vo.getSalesAmountNoTaxStr());
            entity.setSalesAmountNoTax(salesAmountNoTax);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getSalesAmountStr())) {
            BigDecimal salesAmount = new BigDecimal(vo.getSalesAmountStr());
            entity.setSalesAmount(salesAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getReceiptAmountStr())) {
            BigDecimal receiptAmount = new BigDecimal(vo.getReceiptAmountStr());
            entity.setReceiptAmount(receiptAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getPromotionDeductionStr())) {
            BigDecimal promotionDeduction = new BigDecimal(vo.getPromotionDeductionStr());
            entity.setPromotionDeduction(promotionDeduction);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getPromotionAmountStr())) {
            BigDecimal PromotionAmount = new BigDecimal(vo.getPromotionAmountStr());
            entity.setPromotionAmount(PromotionAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getCouponAmountStr())) {
            BigDecimal couponAmount = new BigDecimal(vo.getCouponAmountStr());
            entity.setCouponAmount(couponAmount);
        }
    }

    private List<SalesDataEntity> adjustData(List<SalesDataEntity> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<SalesDataEntity>();
        }
        Map fomatMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format"}));
        Map unitMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_unit"}));
        for (SalesDataEntity entity : data) {
            entity.setBusinessFormatCode(DictValueUtil.findDictValue(fomatMap, "mdm_business_format", entity.getBusinessFormatCode()));
            entity.setBusinessUnitCode(DictValueUtil.findDictValue(unitMap, "mdm_business_unit", entity.getBusinessUnitCode()));
        }
        return data;
    }

    public Class<InvoiceSalesImportsVo> findCrmExcelVoClass() {
        return InvoiceSalesImportsVo.class;
    }

    public String getTemplateCode() {
        return "KMS_INVOICE_SALES_DATA_IMPORT";
    }

    public String getTemplateName() {
        return "KMS\u5355\u636e--POS\u6570\u636e";
    }
}

