/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.sales.data.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataGrabEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.mapper.SalesDataGrabMapper;
import com.biz.crm.kms.business.invoice.sales.data.local.model.SalesDataGrabConditionModel;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class SalesDataGrabRepository
extends ServiceImpl<SalesDataGrabMapper, SalesDataGrabEntity> {
    public List<SalesDataGrabEntity> findByOrderNumbers(String tenantCode, List<String> orderNumbers) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(SalesDataGrabEntity::getOrderNumber, orderNumbers)).list();
    }

    public List<SalesDataGrabEntity> findBySalesDataGrabConditionModel(SalesDataGrabConditionModel model) {
        return ((SalesDataGrabMapper)this.baseMapper).findBySalesDataGrabConditionModel(model);
    }

    public Page<String> findSaleDataGrabPage(Pageable pageable, String tenantCode, List<String> transStatusList, String day) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((SalesDataGrabMapper)this.baseMapper).findSaleDataGrabPage((Page<String>)page, tenantCode, transStatusList, day);
    }

    public void updateTransStatusByOrderNumberList(String tenantCode, GrabTransStatus transStatus, List<String> orderNumberList) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || Objects.isNull(transStatus) || CollectionUtil.isEmpty(orderNumberList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(SalesDataGrabEntity::getOrderNumber, orderNumberList)).set(SalesDataGrabEntity::getTransStatus, (Object)transStatus.getDictCode())).update();
    }
}

