/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.sales.data.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.mapper.SalesDataMapper;
import com.biz.crm.kms.business.invoice.sales.data.local.model.SalesDataConditionModel;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalesDataRepository
extends ServiceImpl<SalesDataMapper, SalesDataEntity> {
    @Autowired(required=false)
    private SalesDataMapper salesDataMapper;

    public void deleteByOrderNumber(String tenantCode, String orderNumber) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(SalesDataEntity::getOrderNumber, (Object)orderNumber)).remove();
    }

    public List<SalesDataEntity> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public SalesDataEntity findByOrderNumber(String tenantCode, String orderNumber) {
        return (SalesDataEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(SalesDataEntity::getOrderNumber, (Object)orderNumber)).one());
    }

    public List<SalesDataEntity> findByOrderNumberList(String tenantCode, List<String> orderNumberList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(SalesDataEntity::getOrderNumber, orderNumberList)).list();
    }

    public List<SalesDataEntity> findBySalesDataConditionModel(SalesDataConditionModel model) {
        return ((SalesDataMapper)this.baseMapper).findBySalesDataConditionModel(model);
    }

    public SalesDataEntity findByCondition(String orderNumber, String kaGoodsCode, String kaStoreCode, String salesDate) {
        return (SalesDataEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(SalesDataEntity::getSalesDate, (Object)salesDate)).eq(SalesDataEntity::getOrderNumber, (Object)orderNumber)).eq(SalesDataEntity::getKaGoodsCode, (Object)kaGoodsCode)).eq(SalesDataEntity::getKaStoreCode, (Object)kaStoreCode)).one());
    }

    public List<SalesDataEntity> findByOrderNumbers(Set<String> orderNumbers) {
        if (CollectionUtils.isEmpty(orderNumbers)) {
            return new ArrayList<SalesDataEntity>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(SalesDataEntity::getOrderNumber, orderNumbers)).list();
    }

    public SalesDataVo findCondition(QueryConditionDto dto) {
        return this.salesDataMapper.findCondition(dto);
    }
}

