/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.sales.data.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.repository.SalesDataRepository;
import com.biz.crm.kms.business.invoice.sales.data.local.service.InvoiceSalesDataImportsService;
import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataLogEventDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.event.SalesDataLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="invoiceSalesDataImportsService")
public class InvoiceSalesDataImportsServiceImpl
implements InvoiceSalesDataImportsService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceSalesDataImportsServiceImpl.class);
    @Autowired
    private SalesDataService salesDataService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private SalesDataRepository salesDataRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importsCreate(List<SalesDataEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(aa -> {
            SalesDataEntity entity = this.salesDataRepository.findByOrderNumber(TenantUtils.getTenantCode(), aa.getOrderNumber());
            Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)entity)), (String)"\u5b58\u5728\u8be5POS\u6570\u636e", (Object[])new Object[0]);
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
            aa.setInvoicesSource("\u624b\u52a8\u5bfc\u5165");
        });
        this.salesDataService.create(list);
        Collection invoiceStatementDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list, SalesDataEntity.class, SalesDataDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        invoiceStatementDtos.forEach(dto -> {
            SalesDataLogEventDto logEventDto = new SalesDataLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = SalesDataLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesDataLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }
}

