/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.sales.data.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductUnitVo;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.repository.SalesDataGrabRepository;
import com.biz.crm.kms.business.invoice.sales.data.local.repository.SalesDataRepository;
import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataGrabsThreadService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.enums.SalesDataStatus;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.mn.common.base.service.RedisCrmService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="salesDataGrabsThreadService")
public class SalesDataGrabsThreadServiceImpl
implements SalesDataGrabsThreadService {
    private static final Logger log = LoggerFactory.getLogger(SalesDataGrabsThreadServiceImpl.class);
    @Autowired
    private SalesDataRepository salesDataRepository;
    @Autowired
    private SalesDataGrabRepository salesDataGrabRepository;
    @Autowired
    private RedisCrmService redisCrmService;
    @Autowired(required=false)
    private RedisTemplate redisTemplate;

    @Override
    @Async(value="grab2Thread")
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void saveSalesData(List<SalesDataEntity> entities, Map<String, List<DirectVo>> directMap, Map<String, List<DirectStoreVo>> directStoreMap, Map<String, List<DirectProductVo>> directProductMap) {
        log.info("--  \u8fdb\u5165\u7ebf\u7a0b\u6c60\u5b58\u50a8\u6570\u636e  --");
        List orderNumbers = entities.stream().map(SalesDataEntity::getOrderNumber).collect(Collectors.toList());
        HashSet orderNumberSet = new HashSet();
        HashSet orderNumberSuccessSet = new HashSet();
        entities.forEach(entity -> {
            try {
                this.redisCrmService.hdel("KMS:SALES:DATA:CONVERT:LOCK", new Object[]{entity.getOrderNumber()});
                this.clearTransformInfoOne((SalesDataEntity)((Object)entity), directMap);
                if (StringUtils.isNotBlank((CharSequence)entity.getKaStoreCode())) {
                    String deliveryCode = this.buildOrderInfoTwo((SalesDataEntity)((Object)entity), directStoreMap);
                    if (StringUtils.isEmpty((CharSequence)entity.getKaGoodsCode())) {
                        this.convertAcceptanceOrderItemThree((SalesDataEntity)((Object)entity), directProductMap, deliveryCode);
                    }
                } else {
                    entity.setOrderStatusMsg(null);
                    entity.setOrderStatus(InvoicesStatus.S200.getDictCode());
                }
                entity = this.setAccount((SalesDataEntity)((Object)entity));
                this.setOrderStatusAndMsgFour((SalesDataEntity)((Object)entity));
                this.salesDataRepository.saveOrUpdate(entity);
                if (Objects.equals(InvoicesStatus.S200.getDictCode(), entity.getOrderStatus())) {
                    orderNumberSuccessSet.add(entity.getOrderNumber());
                } else {
                    orderNumberSet.add(entity.getOrderNumber());
                }
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u9500\u552e\u6570\u636e\u6570\u636e\u5931\u8d25", (Throwable)e);
                entity.setOrderStatus(InvoicesStatus.S100.getDictCode());
                entity.setTransFlag(BooleanEnum.TRUE.getCapital());
                entity.setOrderStatusMsg("\u8f6c\u6362\u65f6\u5f02\u5e38!");
                try {
                    this.salesDataRepository.saveOrUpdate(entity);
                    orderNumberSet.add(entity.getOrderNumber());
                }
                catch (Exception ex) {
                    log.error("", (Throwable)ex);
                }
            }
        });
        if (CollectionUtil.isEmpty(orderNumberSet) && CollectionUtils.isEmpty(orderNumberSuccessSet)) {
            return;
        }
        this.redisCrmService.hdel("KMS:SALES:DATA:CONVERT:LOCK", new Object[]{orderNumbers});
        try {
            if (!CollectionUtils.isEmpty(orderNumberSet)) {
                this.salesDataGrabRepository.updateTransStatusByOrderNumberList(TenantUtils.getTenantCode(), GrabTransStatus.TRANS_FAIL, new ArrayList<String>(orderNumberSet));
            }
            if (!CollectionUtils.isEmpty(orderNumberSuccessSet)) {
                this.salesDataGrabRepository.updateTransStatusByOrderNumberList(TenantUtils.getTenantCode(), GrabTransStatus.HAVE_TRANS, new ArrayList<String>(orderNumberSuccessSet));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private SalesDataEntity setAccount(SalesDataEntity entity) {
        BigDecimal decimal = new BigDecimal(1);
        Map map = this.redisTemplate.hasKey((Object)"KMS:CACHE:PRODUCT_TAX_RATE") != false ? (Map)this.redisTemplate.opsForValue().get((Object)"KMS:CACHE:PRODUCT_TAX_RATE") : null;
        String goodsCode = entity.getGoodsCode();
        if (!StringUtils.isEmpty((CharSequence)goodsCode)) {
            BigDecimal multiply;
            if (Objects.isNull(map)) {
                return entity;
            }
            BigDecimal bigDecimal = (BigDecimal)map.get(goodsCode);
            if (Objects.isNull(bigDecimal)) {
                return entity;
            }
            BigDecimal amount = entity.getSalesAmount();
            BigDecimal amountNot = entity.getSalesAmountNoTax();
            if (Objects.nonNull(amount) && BigDecimal.ZERO.compareTo(amount) != 0) {
                multiply = amount.divide(decimal.add(bigDecimal).setScale(4, 4), 4, 4);
                entity.setSalesAmountNoTax(multiply);
            }
            if (Objects.nonNull(amountNot) && BigDecimal.ZERO.compareTo(amountNot) != 0) {
                multiply = amountNot.multiply(decimal.add(bigDecimal).setScale(4, 4));
                entity.setSalesAmount(multiply.setScale(4, 4));
            }
        }
        return entity;
    }

    public void clearTransformInfoOne(SalesDataEntity entity, Map<String, List<DirectVo>> directMap) {
        List<DirectVo> directVos;
        entity.setStoreCode(null);
        entity.setStoreName(null);
        entity.setAreaName(null);
        entity.setAreaCode(null);
        if (StringUtils.isNotBlank((CharSequence)entity.getSalesDate())) {
            try {
                entity.setOrderTime(new SimpleDateFormat("yyyy-MM-dd").parse(entity.getSalesDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isEmpty(directVos = directMap.get(entity.getDirectCode()))) {
            entity.setOrderStatusMsg("\u4e0d\u5b58\u5728\u8be5\u7cfb\u7edf");
        } else {
            DirectVo directVo = directVos.get(0);
            entity.setBusinessFormatCode(directVo.getBusinessFormatCode());
            entity.setBusinessUnitCode(directVo.getBusinessUnitCode());
            entity.setDirectCode(directVo.getDirectCode());
            entity.setDirectName(directVo.getSupermarketName());
            entity.setKaName(directVo.getSupermarketName());
        }
    }

    public String buildOrderInfoTwo(SalesDataEntity entity, Map<String, List<DirectStoreVo>> directStoreMap) {
        entity.setOrderStatus(SalesDataStatus.S100.getDictCode());
        entity.setSoldToPartyName(null);
        entity.setSoldToPartyCode(null);
        if (StringUtils.isBlank((CharSequence)entity.getDirectCode())) {
            entity.setOrderStatusMsg("\u7cfb\u7edf\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)entity.getKaStoreCode())) {
            entity.setOrderStatusMsg("\u5355\u636e\u5546\u8d85\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        List<DirectStoreVo> directStoreList = directStoreMap.get(entity.getDirectCode() + "_" + entity.getKaStoreCode());
        DirectStoreVo directStoreVo = null;
        if (CollectionUtil.isEmpty(directStoreList)) {
            entity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
            return null;
        }
        if (directStoreList.size() > 1) {
            entity.setOrderStatusMsg("\u5546\u8d85\u95e8\u5e97\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb\u5b58\u5728[" + directStoreList.size() + "]\u6761");
            return null;
        }
        directStoreVo = directStoreList.get(0);
        entity.setSoldToPartyCode(directStoreVo.getSoldToPartyCode());
        entity.setSoldToPartyName(directStoreVo.getSoldToPartyName());
        entity.setDeliveryPartyCode(directStoreVo.getTerminalCode());
        entity.setDeliveryPartyName(directStoreVo.getTerminalName());
        entity.setKaStoreCode(directStoreVo.getSupermarketStoreCode());
        if (StringUtils.isEmpty((CharSequence)entity.getKaStoreName())) {
            entity.setKaStoreName(directStoreVo.getSupermarketStoreName());
        }
        entity.setAreaName(directStoreVo.getRetailerRegion());
        entity.setBusinessArea(directStoreVo.getBusinessArea());
        entity.setProvinceCode(directStoreVo.getProvinceCode());
        entity.setProvinceName(directStoreVo.getProvinceName());
        return directStoreVo.getRetailerTerminalCode();
    }

    public void convertAcceptanceOrderItemThree(SalesDataEntity entity, Map<String, List<DirectProductVo>> directProductMap, String deliveryCode) {
        List<DirectProductVo> productVos;
        if (StringUtils.isBlank((CharSequence)entity.getKaGoodsCode())) {
            entity.setOrderStatusMsg("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            return;
        }
        DirectProductVo productVo = null;
        List<Object> productVoList = new ArrayList<DirectProductVo>();
        List<DirectProductVo> productVoLists = directProductMap.get(entity.getDirectCode() + "_" + entity.getDeliveryPartyCode() + "_" + entity.getKaGoodsCode());
        if (CollectionUtil.isNotEmpty(productVoLists)) {
            productVoList.addAll(productVoLists);
        }
        if (CollectionUtil.isEmpty(productVoList) && StringUtils.isNotBlank((CharSequence)deliveryCode) && CollectionUtil.isNotEmpty(productVos = directProductMap.get(entity.getDirectCode() + "_" + deliveryCode + "_" + entity.getKaGoodsCode()))) {
            productVoList.addAll(productVos);
        }
        if (CollectionUtil.isEmpty(productVoList)) {
            entity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
        } else if (productVoList.size() == 1) {
            productVo = (DirectProductVo)productVoList.get(0);
        } else {
            int allSize = productVoList.size();
            if (CollectionUtil.isEmpty(productVoList = productVoList.stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsDefault())).collect(Collectors.toList()))) {
                entity.setOrderStatusMsg("\u5171[" + allSize + "]\u6761\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb,\u65e0\u9ed8\u8ba4\u5bf9\u5e94\u5173\u7cfb");
            } else if (productVoList.size() > 1) {
                entity.setOrderStatusMsg("[" + productVoList.size() + "]\u6761\u9ed8\u8ba4\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
            } else {
                productVo = (DirectProductVo)productVoList.get(0);
            }
        }
        if (Objects.isNull(productVo)) {
            return;
        }
        entity.setGoodsCode(productVo.getProductCode());
        entity.setGoodsName(productVo.getProductName());
        List unitList = productVo.getUnitList();
        if (StringUtils.isNotBlank((CharSequence)entity.getCurUnit())) {
            unitList = unitList.stream().filter(vo -> Objects.nonNull(vo.getKaUnitQuantity()) && Objects.nonNull(vo.getUnitQuantity())).filter(vo -> Objects.equals(entity.getCurUnit(), vo.getKaUnitCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)unitList)) {
            unitList = productVo.getUnitList().stream().filter(vo -> Objects.nonNull(vo.getKaUnitQuantity()) && Objects.nonNull(vo.getUnitQuantity())).filter(vo -> StringUtils.isBlank((CharSequence)vo.getKaUnitCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)unitList)) {
            entity.setOrderStatusMsg("\u672a\u5339\u914d\u4f01\u4e1a\u5546\u54c1\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb");
            return;
        }
        DirectProductUnitVo unitVo = (DirectProductUnitVo)unitList.get(0);
        if (!StringUtils.isEmpty((CharSequence)unitVo.getUnitName())) {
            entity.setCurCompanyUnit(unitVo.getUnitName());
        } else {
            entity.setOrderStatusMsg("\u4f01\u4e1a\u5355\u4f4d\u540d\u79f0\u4e3a\u7a7a");
        }
        if (Objects.nonNull(entity.getCurUnitSalesQuantity())) {
            BigDecimal curUnitAcceptanceQuantity = unitVo.getUnitQuantity().multiply(entity.getCurUnitSalesQuantity()).divide(unitVo.getKaUnitQuantity(), 6, 4);
            entity.setCurCompanyUnitOrderQuantity(curUnitAcceptanceQuantity);
        }
        entity.setOrderStatus(InvoicesStatus.S200.getDictCode());
    }

    public void setOrderStatusAndMsgFour(SalesDataEntity entity) {
        if (Objects.equals(entity.getOrderStatus(), SalesDataStatus.S200.getDictCode())) {
            entity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
        }
    }
}

