/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.sales.data.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.direct.account.sdk.service.DirectAccountVoService;
import com.biz.crm.kms.business.direct.account.sdk.vo.DirectAccountVo;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductDto;
import com.biz.crm.kms.business.direct.product.sdk.service.DirectProductVoService;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductUnitVo;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.sales.data.local.entity.SalesDataEntity;
import com.biz.crm.kms.business.invoice.sales.data.local.model.SalesDataConditionModel;
import com.biz.crm.kms.business.invoice.sales.data.local.register.SaleInvoiceTypeRegister;
import com.biz.crm.kms.business.invoice.sales.data.local.repository.SalesDataRepository;
import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataGrabsService;
import com.biz.crm.kms.business.invoice.sales.data.local.service.SalesDataService;
import com.biz.crm.kms.business.invoice.sdk.enums.ConstantEnums;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.dataphin.sdk.DataphinService;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.PosDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="salesDataService")
public class SalesDataServiceImpl
implements SalesDataService {
    private static final Logger log = LoggerFactory.getLogger(SalesDataServiceImpl.class);
    @Autowired
    private SalesDataRepository salesDataRepository;
    @Autowired
    private DataphinService dataphinService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private SalesDataGrabsService salesDataGrabsService;
    @Autowired(required=false)
    private SaleInvoiceTypeRegister saleInvoiceTypeRegister;
    @Autowired(required=false)
    private DirectAccountVoService directAccountVoService;
    @Autowired(required=false)
    private DirectVoService directVoService;
    @Autowired(required=false)
    private DirectStoreVoService directStoreVoService;
    @Autowired(required=false)
    private DirectProductVoService directProductVoService;
    @Autowired(required=false)
    private RedisTemplate redisTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(List<SalesDataEntity> salesDataEntities) {
        if (CollectionUtils.isEmpty(salesDataEntities)) {
            return;
        }
        salesDataEntities.forEach(aa -> this.salesDataRepository.save(aa));
    }

    @Override
    public List<SalesDataEntity> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        SalesDataConditionModel model = new SalesDataConditionModel();
        model.setIds(ids);
        model.setTenantCode(TenantUtils.getTenantCode());
        return this.salesDataRepository.findBySalesDataConditionModel(model);
    }

    @Override
    public void manualTransSaleData(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SalesDataEntity> entities = this.salesDataRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.notEqual((Object)entities.size(), (Object)ids.size()) ? 1 : 0) != 0, (String)"\u6570\u636e\u8f6c\u6362\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        entities.forEach(entity -> Validate.isTrue((boolean)Lists.newArrayList((Object[])new String[]{InvoicesStatus.S200.getDictCode(), InvoicesStatus.S101.getDictCode(), InvoicesStatus.S100.getDictCode()}).contains(entity.getOrderStatus()), (String)String.format("\u9500\u552e\u6570\u636e[%s]\u5df2\u786e\u8ba4,\u65e0\u6cd5\u7ee7\u7eed\u5339\u914d", entity.getOrderNumber()), (Object[])new Object[0]));
        List<String> orderNumbers = entities.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getOrderNumber())).map(SalesDataEntity::getOrderNumber).distinct().collect(Collectors.toList());
        this.salesDataGrabsService.filterSwitchIngOrderNumberList(orderNumbers);
        log.info("===== \u9500\u552e\u6570\u636e\u624b\u52a8\u8f6c\u6362\u5f00\u59cb ======");
        this.salesDataGrabsService.manualSwitch(orderNumbers);
        log.info("===== \u9500\u552e\u6570\u636e\u624b\u52a8\u8f6c\u6362\u5b8c\u6210 ======");
    }

    @Override
    @DynamicTaskService(cornExpression="0 0 22 * * ?", taskDesc="\u540c\u6b65\u6570\u636e\u4e2d\u53f0POS\u9500\u552e\u6570\u636e")
    @Transactional(rollbackFor={Exception.class})
    public void syncPosData() {
        Date nowTime = new Date();
        String date = DateUtil.format((Date)DateUtil.dateAddDay((Date)nowTime, (Integer)-1), (String)"yyyyMMdd");
        this.posData(date);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void posData(String date) {
        Date nowTime = new Date();
        if (StringUtils.isEmpty((CharSequence)date)) {
            date = DateUtil.format((Date)DateUtil.dateAddDay((Date)nowTime, (Integer)-1), (String)"yyyyMMdd");
        }
        int pageSize = 1000;
        int pageNumber = 0;
        Boolean exitFlag = Boolean.TRUE;
        while (exitFlag.booleanValue()) {
            log.info("\u5f00\u59cb\u67e5\u8be2pos\u6570\u636e");
            List data = this.dataphinService.getPosData(date, pageNumber, pageSize);
            log.info("\u83b7\u53d6\u5230pos\u6570\u636e{}", JSON.toJSON((Object)data));
            if (!CollectionUtils.isEmpty((Collection)data)) {
                Set user = data.stream().map(PosDataVo::getUserName).collect(Collectors.toSet());
                List directAccountVos = this.directAccountVoService.findByAccountList(user.stream().collect(Collectors.toList()));
                if (CollectionUtils.isEmpty((Collection)directAccountVos)) {
                    return;
                }
                Set<String> directCodeSet = directAccountVos.stream().map(DirectAccountVo::getDirectCode).collect(Collectors.toSet());
                List directVos = this.directVoService.findByDirectCodes(directCodeSet.stream().collect(Collectors.toList()));
                HashMap directMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty((Collection)directVos)) {
                    directMap.putAll(directVos.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)k.getBusinessFormatCode())).collect(Collectors.groupingBy(DirectVo::getDirectCode)));
                }
                this.coversAndSave(data, directCodeSet, directMap);
            } else if (CollectionUtils.isEmpty((Collection)data)) {
                exitFlag = false;
                return;
            }
            ++pageNumber;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void getPostDataOne(String date) {
        Date nowTime = new Date();
        if (StringUtils.isEmpty((CharSequence)date)) {
            date = DateUtil.format((Date)DateUtil.dateAddDay((Date)nowTime, (Integer)-1), (String)"yyyyMMdd");
        }
        int pageSize = 1000;
        int pageNumber = 0;
        Boolean exitFlag = Boolean.TRUE;
        while (exitFlag.booleanValue()) {
            log.info("\u5f00\u59cb\u67e5\u8be2pos2\u6570\u636e");
            List dataTwo = this.dataphinService.getPosDataTwo(date, pageNumber, pageSize);
            log.info("\u83b7\u53d6\u5230pos2\u6570\u636e{}", JSON.toJSON((Object)dataTwo));
            if (!CollectionUtils.isEmpty((Collection)dataTwo)) {
                List directVos = this.directVoService.findByDirectCodes((List)Lists.newArrayList((Object[])new String[]{"XAMN-0004"}));
                if (CollectionUtils.isEmpty((Collection)directVos)) {
                    return;
                }
                Map<String, List<DirectVo>> directMapTwo = directVos.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)k.getBusinessFormatCode())).collect(Collectors.groupingBy(DirectVo::getDirectCode));
                this.coversAndSave(dataTwo, Sets.newHashSet((Object[])new String[]{"XAMN-0004"}), directMapTwo);
            } else if (CollectionUtils.isEmpty((Collection)dataTwo)) {
                exitFlag = false;
                return;
            }
            ++pageNumber;
        }
    }

    private void coversAndSave(List<PosDataVo> data, Set<String> directCodeSet, Map<String, List<DirectVo>> directMap) {
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        Set<String> kaStoreCodes = data.stream().map(PosDataVo::getKaStoreCode).collect(Collectors.toSet());
        Set<String> kaGoodsCodes = data.stream().map(PosDataVo::getKaGoodsCode).collect(Collectors.toSet());
        Map<String, List<DirectStoreVo>> directStoreMap = this.buildStoreInfo(directCodeSet, kaStoreCodes);
        HashSet deliveryPartyCodeSet = Sets.newHashSet();
        if (CollectionUtil.isNotEmpty(directStoreMap)) {
            directStoreMap.values().stream().filter(CollUtil::isNotEmpty).forEach(directStoreVoList -> directStoreVoList.forEach(entity -> deliveryPartyCodeSet.add(entity.getTerminalCode())));
        }
        Map<String, List<DirectProductVo>> directProductMap = this.buildProductInfo(directCodeSet, deliveryPartyCodeSet, kaGoodsCodes);
        ArrayList username = new ArrayList();
        Collection<SalesDataEntity> entities = this.nebulaToolkitService.copyCollectionByWhiteList(data, PosDataVo.class, SalesDataEntity.class, HashSet.class, ArrayList.class, new String[0]);
        entities.forEach(o -> {
            List directStoreVoList;
            if (StringUtils.isBlank((CharSequence)o.getUserName())) {
                o.setOrderNumber("WEM-" + o.getKaStoreCode() + "-" + o.getKaGoodsCode() + "-" + o.getSalesDate().replaceAll("-", "").substring(0, 8));
                o.setDirectCode("XAMN-0004");
            } else {
                o.setOrderNumber(o.getUserName() + "-" + o.getKaStoreCode() + "-" + o.getKaGoodsCode() + "-" + o.getSalesDate().replaceAll("-", "").substring(0, 8));
                username.clear();
                username.add(o.getUserName());
                List directAccountVoList = this.directAccountVoService.findByAccountList(username);
                if (CollectionUtils.isEmpty((Collection)directAccountVoList)) {
                    return;
                }
                o.setDirectCode(((DirectAccountVo)directAccountVoList.get(0)).getDirectCode());
            }
            if (StringUtils.isNotBlank((CharSequence)o.getSalesDate())) {
                try {
                    o.setOrderTime(new SimpleDateFormat("yyyy-MM-dd").parse(o.getSalesDate()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            o.setId(IdUtil.fastUUID().replace("-", ""));
            if (!CollectionUtils.isEmpty((Map)directMap)) {
                List directVoList = (List)directMap.get(o.getDirectCode());
                DirectVo directVo = (DirectVo)directVoList.get(0);
                o.setBusinessFormatCode(directVo.getBusinessFormatCode());
                o.setBusinessUnitCode(directVo.getBusinessUnitCode());
                o.setDirectCode(directVo.getDirectCode());
                o.setDirectName(directVo.getSupermarketName());
                o.setKaCode(directVo.getSupermarketCode());
                o.setKaName(directVo.getSupermarketName());
            }
            if (!CollectionUtils.isEmpty((Map)directStoreMap) && !CollectionUtils.isEmpty((Collection)(directStoreVoList = (List)directStoreMap.get(o.getDirectCode() + "_" + o.getKaStoreCode())))) {
                DirectStoreVo directStoreVo = (DirectStoreVo)directStoreVoList.get(0);
                o.setSoldToPartyCode(directStoreVo.getSoldToPartyCode());
                o.setSoldToPartyName(directStoreVo.getSoldToPartyName());
                o.setDeliveryPartyCode(directStoreVo.getTerminalCode());
                o.setDeliveryPartyName(directStoreVo.getTerminalName());
                o.setAreaName(directStoreVo.getRetailerRegion());
                o.setBusinessArea(directStoreVo.getBusinessArea());
            }
            if (!CollectionUtils.isEmpty((Map)directProductMap)) {
                if (StringUtils.isBlank((CharSequence)o.getKaGoodsCode())) {
                    o.setOrderStatusMsg("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
                    return;
                }
                DirectProductVo productVo = null;
                List productVoList = (List)directProductMap.get(o.getDirectCode() + "_" + o.getDeliveryPartyCode() + "_" + o.getKaGoodsCode());
                if (CollectionUtil.isEmpty((Collection)productVoList)) {
                    o.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
                } else if (productVoList.size() == 1) {
                    productVo = (DirectProductVo)productVoList.get(0);
                } else {
                    int allSize = productVoList.size();
                    if (CollectionUtil.isEmpty(productVoList = productVoList.stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsDefault())).collect(Collectors.toList()))) {
                        o.setOrderStatusMsg("\u5171[" + allSize + "]\u6761\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb,\u65e0\u9ed8\u8ba4\u5bf9\u5e94\u5173\u7cfb");
                    } else if (productVoList.size() > 1) {
                        o.setOrderStatusMsg("[" + productVoList.size() + "]\u6761\u9ed8\u8ba4\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
                    } else {
                        productVo = (DirectProductVo)productVoList.get(0);
                    }
                }
                if (Objects.isNull(productVo)) {
                    return;
                }
                o.setGoodsCode(productVo.getProductCode());
                o.setGoodsName(productVo.getProductName());
                List unitList = productVo.getUnitList();
                if (StringUtils.isNotBlank((CharSequence)o.getCurUnit())) {
                    String curUnit = o.getCurUnit();
                    unitList = unitList.stream().filter(vo -> Objects.nonNull(vo.getKaUnitQuantity()) && Objects.nonNull(vo.getUnitQuantity())).filter(vo -> Objects.equals(curUnit, vo.getKaUnitCode())).collect(Collectors.toList());
                }
                if (CollectionUtils.isEmpty((Collection)unitList)) {
                    unitList = productVo.getUnitList().stream().filter(vo -> Objects.nonNull(vo.getKaUnitQuantity()) && Objects.nonNull(vo.getUnitQuantity())).filter(vo -> StringUtils.isBlank((CharSequence)vo.getKaUnitCode())).collect(Collectors.toList());
                }
                if (CollectionUtils.isEmpty((Collection)unitList)) {
                    o.setOrderStatusMsg("\u672a\u5339\u914d\u4f01\u4e1a\u5546\u54c1\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb");
                    return;
                }
                DirectProductUnitVo unitVo = (DirectProductUnitVo)unitList.get(0);
                o.setCurCompanyUnit(unitVo.getUnitName());
                if (!StringUtils.isEmpty((CharSequence)unitVo.getUnitName())) {
                    o.setCurCompanyUnit(unitVo.getUnitName());
                } else {
                    o.setOrderStatusMsg("\u4f01\u4e1a\u5355\u4f4d\u540d\u79f0\u4e3a\u7a7a");
                }
                if (Objects.nonNull(o.getCurUnitSalesQuantity())) {
                    BigDecimal curUnitAcceptanceQuantity = unitVo.getUnitQuantity().multiply(o.getCurUnitSalesQuantity()).divide(unitVo.getKaUnitQuantity(), 6, 4);
                    o.setCurCompanyUnitOrderQuantity(curUnitAcceptanceQuantity);
                }
            }
            o.setTenantCode(TenantUtils.getTenantCode());
            o.setCreateName(loginUser.getRealName());
            o.setCreateAccount(loginUser.getAccount());
            o.setCreateTime(new Date());
            o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (StringUtils.isEmpty((CharSequence)o.getOrderStatusMsg())) {
                o.setOrderStatus(InvoicesStatus.S200.getDictCode());
                o.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
            } else {
                o.setOrderStatus(InvoicesStatus.S100.getDictCode());
            }
            o.setInvoicesSource("\u63a5\u53e3\u5bfc\u5165");
            o = this.setAccount((SalesDataEntity)((Object)o));
        });
        Set<String> orderNumbers = entities.stream().map(SalesDataEntity::getOrderNumber).collect(Collectors.toSet());
        List<SalesDataEntity> salesDataEntities = this.salesDataRepository.findByOrderNumbers(orderNumbers);
        if (!CollectionUtils.isEmpty(salesDataEntities)) {
            List ids = salesDataEntities.stream().map(UuidEntity::getId).collect(Collectors.toList());
            this.salesDataRepository.removeByIds(ids);
        }
        entities = entities.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getDirectCode())).filter(f -> StringUtils.isNotBlank((CharSequence)f.getDeliveryPartyCode())).filter(f -> StringUtils.isNotBlank((CharSequence)f.getGoodsCode())).filter(f -> Objects.nonNull(f.getCurCompanyUnitOrderQuantity())).collect(Collectors.toMap(SalesDataEntity::getOrderNumber, v -> v, (oldValue, newValue) -> newValue)).values();
        List salesDataEntityList = entities.stream().collect(Collectors.toList());
        this.salesDataRepository.saveBatch(salesDataEntityList);
    }

    private Map<String, List<DirectStoreVo>> buildStoreInfo(Set<String> directCodeSet, Set<String> kaStoreCodes) {
        HashMap directStoreMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(kaStoreCodes) || CollectionUtil.isEmpty(directCodeSet)) {
            return directStoreMap;
        }
        DirectStoreConditionDto conditionDto = new DirectStoreConditionDto();
        conditionDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        conditionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        conditionDto.setSupermarketStoreCodes(kaStoreCodes);
        conditionDto.setDirectCodes(directCodeSet);
        List directStoreList = this.directStoreVoService.findByDirectStoreConditionDto(conditionDto);
        if (CollectionUtil.isNotEmpty((Collection)directStoreList)) {
            directStoreMap.putAll(directStoreList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDirectCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getSupermarketStoreCode())).collect(Collectors.groupingBy(k -> k.getDirectCode() + "_" + k.getSupermarketStoreCode())));
        }
        return directStoreMap;
    }

    private Map<String, List<DirectProductVo>> buildProductInfo(Set<String> directCodeSet, Set<String> deliveryPartyCodeSet, Set<String> kaGoodsCodes) {
        HashMap directProductMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(directCodeSet) || CollectionUtil.isEmpty(deliveryPartyCodeSet) || CollectionUtil.isEmpty(kaGoodsCodes)) {
            return directProductMap;
        }
        List kaProductCodeGroupList = Lists.partition((List)Lists.newArrayList(kaGoodsCodes), (int)ConstantEnums.PRODUCT_SIZE.getValue());
        DirectProductDto directProductDto = new DirectProductDto();
        directProductDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        directProductDto.setTenantCode(TenantUtils.getTenantCode());
        directProductDto.setOnShelfStatus(BooleanEnum.TRUE.getCapital());
        directProductDto.setDirectCodes(new ArrayList<String>(directCodeSet));
        directProductDto.setDeliveryPartyCodes(new ArrayList<String>(deliveryPartyCodeSet));
        directProductDto.setOrderType(this.saleInvoiceTypeRegister.type());
        kaProductCodeGroupList.forEach(kaProductCodeList -> {
            directProductDto.setKaProductCodes(kaProductCodeList);
            List productList = this.directProductVoService.findByDirectProductDto(directProductDto);
            if (CollectionUtil.isNotEmpty((Collection)productList)) {
                directProductMap.putAll(productList.stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getOnShelfStatus())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getDirectCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getDeliveryPartyCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getKaProductCode())).collect(Collectors.groupingBy(k -> k.getDirectCode() + "_" + k.getDeliveryPartyCode() + "_" + k.getKaProductCode())));
            }
        });
        return directProductMap;
    }

    private SalesDataEntity setAccount(SalesDataEntity entity) {
        BigDecimal decimal = new BigDecimal(1);
        Map map = this.redisTemplate.hasKey((Object)"KMS:CACHE:PRODUCT_TAX_RATE") != false ? (Map)this.redisTemplate.opsForValue().get((Object)"KMS:CACHE:PRODUCT_TAX_RATE") : null;
        String goodsCode = entity.getGoodsCode();
        if (!StringUtils.isEmpty((CharSequence)goodsCode)) {
            BigDecimal multiply;
            if (Objects.isNull(map)) {
                return entity;
            }
            BigDecimal bigDecimal = (BigDecimal)map.get(goodsCode);
            if (Objects.isNull(bigDecimal)) {
                return entity;
            }
            BigDecimal amount = entity.getSalesAmount();
            BigDecimal amountNot = entity.getSalesAmountNoTax();
            if (Objects.nonNull(amount) && BigDecimal.ZERO.compareTo(amount) != 0) {
                multiply = amount.divide(decimal.add(bigDecimal).setScale(4, 4), 4, 4);
                entity.setSalesAmountNoTax(multiply);
            }
            if (Objects.nonNull(amountNot) && BigDecimal.ZERO.compareTo(amountNot) != 0) {
                multiply = amountNot.multiply(decimal.add(bigDecimal).setScale(4, 4));
                entity.setSalesAmount(multiply.setScale(4, 4));
            }
            if (Objects.nonNull(entity.getCurUnitSalesQuantity()) && BigDecimal.ZERO.compareTo(entity.getCurUnitSalesQuantity()) != 0) {
                if (Objects.nonNull(entity.getSalesAmountNoTax())) {
                    entity.setSalesCostNot(entity.getSalesAmountNoTax().divide(entity.getCurUnitSalesQuantity(), 4, 4));
                }
                if (Objects.nonNull(entity.getSalesAmount())) {
                    entity.setSalesCost(entity.getSalesAmount().divide(entity.getCurUnitSalesQuantity(), 4, 4));
                }
            }
        }
        return entity;
    }
}

