package com.biz.crm.kms.business.invoice.sales.data.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 销售数据常量类
 *
 * @author ning.zhang
 * @date 2022/11/7
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class SalesDataConstant {

  /**
   * KMS单据验收单 MQ topic
   */
  public static final String KMS_SALES_DATA_TOPIC = "KMS_SALES_DATA_TOPIC";

  /**
   * 销售数据redis锁定时间
   * */
  public static final Integer SALES_DATA_REDIS_TIME = 1800;

  /**
   * 销售数据自动转换 分页size
   */
  public static final Integer SALES_DATA_PAGE_SIZE = 800;

  /**
   * 销售数据自动转换 分页后最大循环次数  和 上个参数配合使用
   * 自动转换单词最大自动转换数量为   {@link SALES_DATA_PAGE_SIZE }*{@link SALES_DATA_LOOP_MAX }
   */
  public static final Integer SALES_DATA_LOOP_MAX = 1000;

  /**
   * 销售数据tag
   */
  public static final String SALES_DATA_MESSAGE_TAG = "KMS_SALES_DATA_MESSAGE_TAG";

  /**
   * 销售数据redis锁前缀
   */
  public static final String SALES_DATA_CONVERT_LOCK = "KMS:SALES:DATA:CONVERT:LOCK";

  /**
   * 销售数据自动转换redis锁前缀
   * */
  public static final String SALES_DATA_AUTO_NOT_CONVERT_LOCK = "KMS:SALES:DATA:AUTO_NOT_CONVERT:LOCK";

  /**
   * 销售数据自动转换redis锁前缀
   * */
  public static final String SALES_DATA_AUTO_FAIL_CONVERT_LOCK = "KMS:SALES:DATA:AUTO_FAIL_CONVERT:LOCK";

  /**
   * 销售数据转换成功描述
   */
  public static final String SALES_DATA_CONVERT_SUCCESS_MSG = "转换成功";
  /**
   * 单据来源--接口导入
   */
  public static final String SALES_DATA_IMPORT_INTERFACE = "接口导入";
}
