package com.biz.crm.kms.business.invoice.sales.data.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;


@Data
public class QueryConditionDto {

    @ApiModelProperty("送达方编码")
    private String deliveryPartyCode;

    @ApiModelProperty("商超门店编号")
    private String kaStoreCode;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("零售商产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("开始时间/日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startTimeOrDate;

    @ApiModelProperty("结束时间/日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endTimeOrDate;

}
