package com.biz.crm.kms.business.invoice.sales.data.sdk.dto;

import com.biz.crm.kms.business.invoice.sales.data.sdk.enums.SalesDataStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author cyj
 * @Description 单据--销售数据请求参数
 * @date 2022/11/28 15:53
 * @description SalesDataDto
 */
@Data
public class SalesDataDto {

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码")
    private String directCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称")
    private String directName;

    /**
     * KMS销售数据单号
     */
    @ApiModelProperty(value = "KMS销售数据单号")
    private String orderNumber;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(value = "送达方编码")
    private String deliveryPartyCode;

    @ApiModelProperty(value = "送达方名称")
    private String deliveryPartyName;

    /**
     * 零售商编码
     */
    @ApiModelProperty(value = "零售商编码")
    private String kaCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(value = "零售商名称")
    private String kaName;


    /**
     * 销售数据版本号
     */
    @ApiModelProperty(value = "销售数据版本号")
    private Integer versionNumber;

    /**
     * 商超销售数据编号
     */
    @ApiModelProperty(value = "商超销售数据编号")
    private String kaOrderNumber;

    /**
     * 单据来源
     */
    @ApiModelProperty(value = "单据来源")
    private String invoicesSource;



    /**
     * 销售日期
     */
    @ApiModelProperty(value = "销售日期")
    private String salesDate;


    /**
     * 商超门店/大仓编号
     */
    @ApiModelProperty(value = "商超门店/大仓编号")
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @ApiModelProperty(value = "商超门店/大仓名称")
    private String kaStoreName;

    /**
     * 企业门店/大仓编号
     */
    @ApiModelProperty(value = "企业门店/大仓编号")
    private String storeCode;

    /**
     * 企业门店/大仓名称
     */
    @ApiModelProperty(value = "企业门店/大仓名称")
    private String storeName;

    /**
     * 是否能再次转换标示(Y:是,N:否)
     */
    @ApiModelProperty(value = "是否能再次转换标示(Y:是,N:否)")
    private String transFlag;

    /**
     * 售达方名称
     */
    @ApiModelProperty(value = "售达方名称")
    private String soldToPartyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty(value = "售达方编码")
    private String soldToPartyCode;

    /**
     * 企业产品编号
     */
    @ApiModelProperty(value = "企业产品编号")
    private String goodsCode;

    /**
     * 企业产品名称
     */
    @ApiModelProperty(value = "企业产品名称")
    private String goodsName;

    /**
     * 零售商产品编号
     */
    @ApiModelProperty(value = "零售商产品编号")
    private String kaGoodsCode;

    /**
     * 零售商产品名称
     */
    @ApiModelProperty(value = "零售商产品名称")
    private String kaGoodsName;

    /**
     * 产品国际条码
     */
    @ApiModelProperty(value = "产品国际条码")
    private String goodsBarCode;

    /**
     * 产品规格
     */
    @ApiModelProperty(value = "产品规格")
    private String specification;

    /**
     * 销售成本
     */
    @ApiModelProperty(value = "销售成本")
    private BigDecimal salesCost;

    /**
     * 销售金额(含税)
     */
    @ApiModelProperty(value = "销售金额(含税)")
    private BigDecimal salesAmount;

    /**
     * 销售金额(不含税)
     */
    @ApiModelProperty(value = "销售金额(不含税)")
    private BigDecimal salesAmountNoTax;

    /**
     * 收货金额
     */
    @ApiModelProperty(value = "收货金额")
    private BigDecimal receiptAmount;

    /**
     * 促销扣款
     */
    @ApiModelProperty(value = "促销扣款")
    private BigDecimal PromotionDeduction;

    /**
     * 促销金额
     */
    @ApiModelProperty(value = "促销金额")
    private BigDecimal PromotionAmount;

    /**
     * 优惠券金额
     */
    @ApiModelProperty(value = "优惠券金额")
    private BigDecimal couponAmount;

    /**
     * 经营方式
     */
    @ApiModelProperty(value = "经营方式")
    private String runMode;

    /**
     * 零售商区域编码
     */
    @ApiModelProperty(value = "零售商区域编码")
    private String areaCode;

    /**
     * 零售商区域名称
     */
    @ApiModelProperty(value = "零售商区域名称")
    private String areaName;

    /**
     * 竞品品牌
     */
    @ApiModelProperty(value = "竞品品牌")
    private String competitiveBrands;

    /**
     * 当前单位层级
     */
    @ApiModelProperty(value = "当前单位层级")
    private String curUnitLevel;

    /**
     * 商超当前单位
     */
    @ApiModelProperty(value = "商超当前单位")
    private String curUnit;

    /**
     * 商超当前单位销售数量
     */
    @ApiModelProperty(value = "商超当前单位销售数量")
    private BigDecimal curUnitSalesQuantity;

    /**
     * 最小单位层级
     */
    @ApiModelProperty(value = "最小单位层级")
    private String minUnitLevel;

    /**
     * 最小单位
     */
    @ApiModelProperty(value = "最小单位")
    private String minUnit;

    /**
     * 最小单位销售数量
     */
    @ApiModelProperty(value = "最小单位销售数量")
    private BigDecimal minUnitSalesQuantity;

    /**
     * 最大单位层级
     */
    @ApiModelProperty(value = "最大单位层级")
    private String maxUnitLevel;

    /**
     * 最小单位
     */
    @ApiModelProperty(value = "最大单位")
    private String maxUnit;

    /**
     * 最大单位销售数量
     */
    @ApiModelProperty(value = "最大单位销售数量")
    private BigDecimal maxUnitSalesQuantity;

    /**
     * 业务区域
     */
    @ApiModelProperty(value = "业务区域")
    private String businessArea;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号")
    private String userName;

    /**
     * 销售数据当前状态
     *
     * @see SalesDataStatus
     */
    @ApiModelProperty(value = "销售数据当前状态")
    private String orderStatus;

    /**
     * 单据当前状态信息
     */
    @ApiModelProperty(value = "单据当前状态信息")
    private String orderStatusMsg;

    /**
     * 状态描述
     */
    @ApiModelProperty(value = "状态描述")
    private String statusMsg;

    /**
     * 企业当前单位
     */
    @ApiModelProperty(value = "企业当前单位")
    private String curCompanyUnit;

    /**
     * 企业单位数量
     */
    @ApiModelProperty(value = "企业当前单位销售数量")
    private BigDecimal curCompanyUnitOrderQuantity;
}
