package com.biz.crm.kms.business.invoice.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 单据查询dto
 *
 * @author songjingen
 * @date 2022/11/2 18:04
 */
@Data
@ApiModel(value = "InvoiceStatisticsDto", description = "单据统计vo")
public class InvoiceStatisticsDto {

  /**
   * 单据日期
   */
  @ApiModelProperty("单据日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private List<Date> invoiceDates;

  /**
   * 物料编码（商品编码）
   */
  @ApiModelProperty("物料编码（商品编码）")
  private List<String> goodsCodes;

  /**
   * 门店编码
   */
  @ApiModelProperty("门店编码")
  private List<String> storeCodes;
}
