package com.biz.crm.kms.business.invoice.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 抓单转换状态
 *
 * @author ning.zhang
 * @date 2022/9/27
 */
@Getter
@AllArgsConstructor
public enum GrabTransStatus {

  /**
   * 未转换
   */
  NOT_TRANS("not_trans", "0", "未转换", 0),

  /**
   * 转换失败
   */
  TRANS_FAIL("trans_fail", "-1", "转换失败", 1),

  /**
   * 已转换
   */
  HAVE_TRANS("have_trans", "1", "已转换", 2),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private Integer order;

  /**
   * 通过字典编码获取枚举值
   *
   * @param dictCode 字典编码
   * @return 取枚举值
   */
  public static GrabTransStatus getByDictCode(String dictCode) {
    GrabTransStatus result = null;
    for (GrabTransStatus type : GrabTransStatus.values()) {
      if (type.getDictCode().equals(dictCode)) {
        result = type;
        break;
      }
    }
    return result;
  }
}
