package com.biz.crm.kms.business.invoice.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
/**
* @Description: 单据转换状态枚举
* @Param:
* @return:
* @Author: ZS
* @Date: 2022/12/15
*/
@Getter
@AllArgsConstructor
public enum InvoicesStatus {

  /**
   * 转换失败
   */
  S100("s100", "100", "转换失败", 0),
  /**
   * 待转换
   */
  S101("s101", "101", "待转换", 1),
  /**
   * 待确认
   */
  S200("s200", "200", "待确认", 2),
  /**
   * 已确认
   */
  S300("s300", "300", "已确认", 3),
  /**
   * 待处理
   */
  S400("s400", "400", "待处理", 4),
  /**
   * 传送SAP成功
   */
  S500("s500", "500", "传送SAP成功", 5),
  /**
   * 传送SAP失败
   */
  S501("s501", "501", "传送SAP失败", 6),
  /**
   * 已匹配
   */
  S600("s600", "600", "页面新增", 7),;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private Integer order;

  /**
   * 通过字典编码获取枚举值
   *
   * @param dictCode 字典编码
   * @return 取枚举值
   */
  public static InvoicesStatus getByDictCode(String dictCode) {
    InvoicesStatus result = null;
    for (InvoicesStatus type : InvoicesStatus.values()) {
      if (type.getDictCode().equals(dictCode)) {
        result = type;
        break;
      }
    }
    return result;
  }
}
