package com.biz.crm.kms.business.invoice.sdk.service;


import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceStatisticsVo;
import java.util.Date;
import java.util.List;

/**
 * 单据类型service
 *
 * @author songjingen
 * @date 2022/9/28
 */
public interface InvoiceStatisticsVoService {

  /**
   * 根据单据类型查询数据
   *
   * @param type           单据类型
   * @param invoiceDates   单据日期
   * @param goodsCodes     商品编码
   * @param storeCodes     门店编码
   * @param kaOrderNumbers 商超订单编码
   * @param args           方法参数，注意这些参数都必须是能够被串行化的参数，否则系统会报错
   * @return
   */
  List<InvoiceStatisticsVo> findByType(String type, List<Date> invoiceDates, List<String> goodsCodes, List<String> storeCodes, List<String> kaOrderNumbers, List... args);

  /**
   * 根据条件查询单据
   *
   * @param type 单据类型
   * @param goodsCodes 产品编码
   * @param storeCodes 门店编码
   * @param orderCodes 采购单号
   * @param soldToPartyCodes 售达方
   * @param directCodes 系统编码
   * @return
   */
  List<InvoiceStatisticsVo> findByConditions(String type,List<String> goodsCodes, List<String> storeCodes,List<String> orderCodes,String beginDate,String endDate,List<String> soldToPartyCodes,List<String> directCodes);

  /**
   * 通过单据类型和关系id查询数据
   * @param relationId
   * @param type
   * @return
   */
  List<InvoiceStatisticsVo> findByRelationId(String type,List<String> relationId);


  /**
   * 窜单匹配查询验收单
   * @param type
   * @param relationKaOrderCodes
   * @param acceptanceOrderNumber
   * @return
   */
  List<InvoiceStatisticsVo> findCrossByConditions(String type,List<String> relationKaOrderCodes,List<String> acceptanceOrderNumber);

}
