package com.biz.crm.kms.business.invoice.sdk.strategy;

import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceStatisticsVo;
import java.util.Date;
import java.util.List;

/**
 * 单据统计策略
 *
 * @author songjingen
 * @date 2022/11/2 15:43
 */
public interface InvoiceStatisticsStrategy {

  /**
   * 单据单据类型
   *
   * @return 单据类型
   */
  String getType();

  /**
   * 根据单据类型查询数据
   *
   * @param invoiceDates   单据日期
   * @param goodsCodes     商品编码
   * @param storeCodes     门店编码
   * @param KaOrderNumbers 商超订单编码集合
   * @param args           方法参数，注意这些参数都必须是能够被串行化的参数，否则系统会报错
   * @return 数据集合
   */
  List<InvoiceStatisticsVo> findInvoiceStatistics(List<Date> invoiceDates, List<String> goodsCodes, List<String> storeCodes, List<String> KaOrderNumbers, List... args);

  /**
   * 根据条件查询单据
   *
   * @param type
   * @param goodsCodes
   * @param storeCodes
   * @param orderCodes
   * @param beginDate
   * @param endDate
   * @param soldToPartyCode
   * @param directCodes
   * @return
   */
  List<InvoiceStatisticsVo> findByConditions(String type, List<String> goodsCodes, List<String> storeCodes, List<String> orderCodes, String beginDate,String endDate, List<String> soldToPartyCode, List<String> directCodes);

  /**
   * 根据invoiceCodes查询数据
   *
   * @param invoiceCodes 单据编码集合
   * @return 数据集合
   */
  List<InvoiceStatisticsVo> findByInvoiceCodes(List<String> invoiceCodes);

  /**
   * 通过单据类型和关系id查询数据
   * @param relationId
   * @return
   */
  List<InvoiceStatisticsVo> findByRelationId(List<String> relationId);

  /**
   * 窜单匹配查询验收单
   * @param relationKaOrderCodes
   * @param acceptanceOrderNumber
   * @return
   */
  List<InvoiceStatisticsVo> findCrossByConditions(List<String> relationKaOrderCodes, List<String> acceptanceOrderNumber);
}
