package com.biz.crm.kms.business.invoice.sdk.vo;

import com.biz.crm.kms.business.invoice.sdk.register.InvoiceTypeRegister;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;

/**
 * 单据统计vo
 *
 * @author songjingen
 * @date 2022/11/2 18:04
 */
@Data
@ApiModel(value = "InvoiceStatisticsVo", description = "单据统计vo")
public class InvoiceStatisticsVo {

  /**
   * 单据类型
   *
   * @see InvoiceTypeRegister#type()
   */
  @ApiModelProperty("单据类型")
  private String invoiceType;

  /**
   * 采购单号
   */
  @ApiModelProperty("采购单号")
  private String orderCode;

  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String superMarketCode;

  /**
   * 单据唯一编码
   */
  @ApiModelProperty("单据唯一编码")
  private String invoiceCode;

  /**
   * 企业单据编码
   */
  @ApiModelProperty("企业单据编码")
  private String orderNumber;

  /**
   * 商超单据编码
   */
  @ApiModelProperty("商超单据编码")
  private String kaOrderNumber;

  /**
   * 单据日期
   */
  @ApiModelProperty("单据日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date invoiceDate;

  /**
   * 物料编码（产品编码）
   */
  @ApiModelProperty("物料编码（产品编码）")
  private String goodsCode;

  /**
   * 物料名称（产品名称）
   */
  @ApiModelProperty("物料编码（产品名称）")
  private String goodsName;

  /**
   * 门店编码
   */
  @ApiModelProperty("门店编码")
  private String storeCode;

  /**
   * 单据数量
   */
  @ApiModelProperty("单据数量")
  private BigDecimal invoiceCount;

  /**
   * 单据金额
   */
  @ApiModelProperty("单据金额")
  private BigDecimal invoiceAmount;

  /**
   * 单据金额（不含税）
   */
  @ApiModelProperty("单据金额（不含税）")
  private BigDecimal invoiceAmountTaxExclusive;

  /**
   * 单据单价
   */
  @ApiModelProperty("单据单价")
  private BigDecimal invoicePrice;

  /**
   * 单据未税单价
   */
  @ApiModelProperty("单据未税单价")
  private BigDecimal invoicePriceNoTax;

  /**
   * 转换状态
   */
  @ApiModelProperty("转换状态")
  private String orderStatus;

  /**
   * 转换状态描述
   */
  @ApiModelProperty("转换状态描述")
  private String orderStatusMsg;
}
