package com.biz.crm.kms.business.invoice.statement.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.statement.feign.feign.internal.InvoiceStatementVoFeignImpl;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDeductionDto;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-kms}",
        path = "crm-kms",
        fallbackFactory = InvoiceStatementVoFeignImpl.class)
public interface InvoiceStatementVoFeign {

    /**
     * @Description: 查询所有结算单数据
     * @Param: [dto]
     * @return: com.biz.crm.business.common.sdk.model.Result<java.util.List<com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto>>
     * @Author: ZS
     * @Date: 2022/11/16
     */
    @GetMapping("/v1/invoiceStatementVo/invoiceStatementVo/findInvoiceStatement")
    Result<List<InvoiceStatementDto>> findInvoiceStatement(@RequestParam InvoiceStatementDto dto);

    /**
     * @Description: 分页查询所有结算单数据
     * @Param: [pageNumber]
     * @Param: [pageSize]
     * @Param: [dto]
     * @return: com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto>>
     * @Author: heding
     * @Date: 2022/11/30
     */
    @ApiOperation(value = "分页查询所有结算单数据")
    @GetMapping(value = {"/v1/invoiceStatementVo/invoiceStatementVo/findInvoiceStatementPaging"})
    Result<Page<InvoiceStatementDto>> findInvoiceStatementPaging( @PageableDefault(50) Pageable pageable,
                                                                 @SpringQueryMap InvoiceStatementDto dto);

    /**
     *  查询结算单的费用详情
     * @param pageable
     * @param dto
     * @return
     */
    @GetMapping("/v1/invoiceStatementVo/invoiceStatementVo/findKmsStatementExpensePage")
    public Result<Page<InvoiceStatementDeductionDto>> findKmsStatementExpensePage(@PageableDefault(50) Pageable pageable,
                                                                                  @SpringQueryMap InvoiceStatementDeductionDto dto);
    }
