package com.biz.crm.kms.business.invoice.statement.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.statement.feign.feign.InvoiceStatementVoFeign;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDeductionDto;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Class InvoiceStatementVoFeignImpl
 * @Description
 * @Author : ZS
 * @Date: 2022/11/16  12:05
 */
@Component
public class InvoiceStatementVoFeignImpl implements FallbackFactory<InvoiceStatementVoFeign> {

    @Override
    public InvoiceStatementVoFeign create(Throwable throwable) {
        return new InvoiceStatementVoFeign() {

            /**
            * @Description: 查询所有结算单数据
            * @Param: [dto]
            * @return: com.biz.crm.business.common.sdk.model.Result<java.util.List<com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto>>
            * @Author: ZS
            * @Date: 2022/11/16
            */
            @Override
            public Result<List<InvoiceStatementDto>> findInvoiceStatement(InvoiceStatementDto dto) {
                throw new UnsupportedOperationException("查询所有结算单数据发生熔断");
            }
            /**
             * @Description: 分页查询所有结算单数据
             * @Param: [pageNumber]
             * @Param: [pageSize]
             * @Param: [dto]
             * @return: com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto>>
             * @Author: heding
             * @Date: 2022/11/30
             */
            @Override
            public Result<Page<InvoiceStatementDto>> findInvoiceStatementPaging(Pageable pageable, InvoiceStatementDto dto) {
                throw new UnsupportedOperationException("分页查询所有结算单数据发生熔断");

            }

            @Override
            public Result<Page<InvoiceStatementDeductionDto>> findKmsStatementExpensePage(Pageable pageable, InvoiceStatementDeductionDto dto) {
                throw new UnsupportedOperationException("分页查询结算单费用详情数据发生熔断");
            }
        };

    }
}
