package com.biz.crm.kms.business.invoice.statement.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.statement.feign.feign.InvoiceStatementVoFeign;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementAccptanceDto;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDeductionDto;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto;
import com.biz.crm.kms.business.invoice.statement.sdk.service.InvoiceStatementVoService;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceAcceptanceVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceExpenseSheetVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceReturnOrderVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceStatementDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Objects;

/**
 * @Class InvoiceStatementVoServiceImpl
 * @Description
 * @Author : ZS
 * @Date: 2022/11/16  10:56
 */
@Service
@Slf4j
public class InvoiceStatementVoServiceImpl implements InvoiceStatementVoService {

    @Autowired
    private InvoiceStatementVoFeign invoiceStatementVoFeign;

    @Override
    public void manualSwitch(List<String> rawDateIds) {

    }

    /**
     * @Description: 查询所有结算单数据
     * @Param: [statementDto]
     * @return: java.util.List<com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto>
     * @Author: ZS
     * @Date: 2022/11/16
     */
    @Override
    public List<InvoiceStatementDto> findInvoiceStatement(InvoiceStatementDto statementDto) {
        return this.invoiceStatementVoFeign.findInvoiceStatement(statementDto).getResult();
    }

    /**
     * @Description: 分页查询所有结算单数据
     * @Param: [pageable]
     * @Param: [dto]
     * @return: com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto>
     * @Author: heding
     * @Date: 2022/11/30
     */
    @Override
    public Page<InvoiceStatementDto> findInvoiceStatementPaging(Pageable pageable, InvoiceStatementDto dto) {
        Result<Page<InvoiceStatementDto>> result = invoiceStatementVoFeign.findInvoiceStatementPaging(pageable, dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public Page<InvoiceAcceptanceVo> findNotMatchAccptance(Pageable pageable, InvoiceAcceptanceVo dto) {
        return null;
    }

    @Override
    public Page<InvoiceReturnOrderVo> findNotMatchReturn(Pageable pageable, InvoiceReturnOrderVo dto) {
        return null;
    }

    @Override
    public Page<InvoiceExpenseSheetVo> findNotMatchExpense(Pageable pageable, InvoiceExpenseSheetVo dto) {
        return null;
    }

    @Override
    public List<InvoiceStatementDataVo> findAllByConditions(String businessUnitCode, String beginDateStr, String endDateStr) {
        return null;
    }

    @Override
    public List<InvoiceStatementDataVo> findAllByConditions(String date, String businessUnitCode) {
        return null;
    }

    @Override
    public InvoiceStatementDataVo findByStatementCode(String statementCode) {
        return null;
    }

    /**
     * 查询结算单的费用详情
     *
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<InvoiceStatementDeductionDto> findKmsStatementExpensePage(Pageable pageable, InvoiceStatementDeductionDto dto) {
        return null;
    }

}
