/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatement;
import com.biz.crm.kms.business.invoice.statement.local.service.InvoiceStatementGrabService;
import com.biz.crm.kms.business.invoice.statement.local.service.InvoiceStatementService;
import com.biz.crm.kms.business.invoice.statement.sdk.service.InvoiceStatementVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/invoiceStatement/invoiceStatement"})
@Api(tags={"\u5355\u636e--\u7ed3\u7b97\u5355\u754c\u9762\u76f8\u5173\u63a5\u53e3"})
public class InvoiceStatementController {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatementController.class);
    @Autowired
    private InvoiceStatementService invoiceStatementService;
    @Autowired
    private InvoiceStatementVoService invoiceStatementVoService;
    @Autowired
    private InvoiceStatementGrabService service;

    @ApiOperation(value="\u7ed3\u7b97\u5355\u624b\u52a8\u8f6c\u6362")
    @PatchMapping(value={"/manualSwitch"})
    public Result<?> manualSwitch(@RequestBody List<String> ids) {
        try {
            this.invoiceStatementVoService.manualSwitch(ids);
            return Result.ok((String)"\u8f6c\u6362\u7ed3\u675f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1")
    @GetMapping(value={"autoJob"})
    public void autoJob() {
        this.service.autoNotConvertStatement();
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"/findById"})
    public Result<InvoiceStatement> findById(@RequestParam(value="id") String id) {
        try {
            InvoiceStatement invoiceStatement = this.invoiceStatementService.findById(id);
            return Result.ok((Object)((Object)invoiceStatement));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<InvoiceStatement> create(@ApiParam(name="invoiceStatement", value="") @RequestBody InvoiceStatement invoiceStatement) {
        try {
            InvoiceStatement result = this.invoiceStatementService.create(invoiceStatement);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<InvoiceStatement> update(@ApiParam(name="invoiceStatement", value="") @RequestBody InvoiceStatement invoiceStatement) {
        try {
            InvoiceStatement result = this.invoiceStatementService.update(invoiceStatement);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.invoiceStatementService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="\u542f\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.invoiceStatementService.enable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="\u7981\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.invoiceStatementService.disable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7ed3\u7b97\u5355\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"/findByStatementCode"})
    public Result<InvoiceStatement> findByStatementCode(@RequestParam(value="statementCode") String statementCode) {
        try {
            InvoiceStatement invoiceStatement = this.invoiceStatementService.findByStatementCode(statementCode);
            return Result.ok((Object)((Object)invoiceStatement));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u540c\u6b65\u7ed3\u7b97\u5355\u53f7")
    @GetMapping(value={"/syncStatementCode"})
    public Result<?> syncStatementCode() {
        try {
            this.invoiceStatementService.syncStatementCode();
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

