/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDeductionDto;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto;
import com.biz.crm.kms.business.invoice.statement.sdk.service.InvoiceStatementVoService;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceAcceptanceVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceExpenseSheetVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceReturnOrderVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5355\u636e--\u7ed3\u7b97\u5355\u5bf9\u5916\u67e5\u8be2\u63a7\u5236\u5c42"})
@RequestMapping(value={"/v1/invoiceStatementVo/invoiceStatementVo"})
public class InvoiceStatementVoController {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatementVoController.class);
    @Autowired
    private InvoiceStatementVoService invoiceStatementVoService;

    @GetMapping(value={"/findInvoiceStatement"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ed3\u7b97\u5355\u6570\u636e")
    public Result<List<InvoiceStatementDto>> findInvoiceStatement(@RequestParam InvoiceStatementDto dto) {
        try {
            List statementDtoList = this.invoiceStatementVoService.findInvoiceStatement(dto);
            return Result.ok((Object)statementDtoList);
        }
        catch (RuntimeException e) {
            log.info(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findInvoiceStatementPaging"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u7ed3\u7b97\u5355\u6570\u636e")
    public Result<Page<InvoiceStatementDto>> findInvoiceStatementPaging(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @RequestBody(required=false) InvoiceStatementDto dto) {
        try {
            Page page = this.invoiceStatementVoService.findInvoiceStatementPaging(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u9a8c\u6536\u5355\u672a\u5173\u8054\u7ed3\u7b97\u5355\u6570\u636e")
    @GetMapping(value={"/findNotMatchAccptance"})
    public Result<Page<InvoiceAcceptanceVo>> findNotMatchAccptance(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u9a8c\u6536\u5355\u5165\u53c2") InvoiceAcceptanceVo dto) {
        try {
            Page expenseSheetVos = this.invoiceStatementVoService.findNotMatchAccptance(pageable, dto);
            return Result.ok((Object)expenseSheetVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u9000\u8d27\u5355\u672a\u5173\u8054\u7ed3\u7b97\u5355\u6570\u636e")
    @GetMapping(value={"/findNotMatchReturn"})
    public Result<Page<InvoiceReturnOrderVo>> findNotMatchReturn(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u9000\u8d27\u5355\u5165\u53c2") InvoiceReturnOrderVo dto) {
        try {
            Page expenseSheetVos = this.invoiceStatementVoService.findNotMatchReturn(pageable, dto);
            return Result.ok((Object)expenseSheetVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u8d39\u7528\u5355\u672a\u5173\u8054\u7ed3\u7b97\u5355\u6570\u636e")
    @GetMapping(value={"/findNotMatchExpense"})
    public Result<Page<InvoiceExpenseSheetVo>> findNotMatchExpense(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u8d39\u7528\u5355\u5165\u53c2") InvoiceExpenseSheetVo dto) {
        try {
            Page expenseSheetVos = this.invoiceStatementVoService.findNotMatchExpense(pageable, dto);
            return Result.ok((Object)expenseSheetVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7ed3\u7b97\u5355\u5173\u8054\u7684\u8d39\u7528\u5355\u8be6\u60c5")
    @GetMapping(value={"/findKmsStatementExpensePage"})
    public Result<Page<InvoiceStatementDeductionDto>> findKmsStatementExpensePage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u8d39\u7528\u5355\u5165\u53c2") InvoiceStatementDeductionDto dto) {
        try {
            Page expenseSheetVos = this.invoiceStatementVoService.findKmsStatementExpensePage(pageable, dto);
            return Result.ok((Object)expenseSheetVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

