/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.business.invoice.statement.local.exports.dto.InvoiceStatementExportDto;
import com.biz.crm.kms.business.invoice.statement.local.exports.mapper.InvoiceStatementExportMapper;
import com.biz.crm.kms.business.invoice.statement.local.exports.vo.InvoiceStatementExportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceStatementExportProcess
implements ExportProcess<InvoiceStatementExportVo> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatementExportProcess.class);
    @Autowired(required=false)
    private InvoiceStatementExportMapper invoiceStatementExportMapper;
    @Autowired
    private DictDataVoService dictDataVoService;

    public Integer getPageSize() {
        return 60000;
    }

    public Integer getTotal(Map<String, Object> params) {
        InvoiceStatementExportDto dto = this.convertParams(params);
        Page<InvoiceStatementExportVo> pageAccResult = this.invoiceStatementExportMapper.findAccByConditions((Page<InvoiceStatementExportVo>)new Page(0L, 1L), dto);
        Page<InvoiceStatementExportVo> pageFeeResult = this.invoiceStatementExportMapper.findFeeByConditions((Page<InvoiceStatementExportVo>)new Page(0L, 1L), dto);
        Page<InvoiceStatementExportVo> pageReturnResult = this.invoiceStatementExportMapper.findReturnByConditions((Page<InvoiceStatementExportVo>)new Page(0L, 1L), dto);
        log.info("\u4e00\u5171\u6709\uff5b" + (int)(pageAccResult.getTotal() + pageFeeResult.getTotal() + pageReturnResult.getTotal()) + "\uff5d\u6761");
        return (int)(pageAccResult.getTotal() + pageFeeResult.getTotal() + pageReturnResult.getTotal());
    }

    public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
        Page<InvoiceStatementExportVo> pageReturn;
        Page<InvoiceStatementExportVo> pageFee;
        if (processVo.getPageNo() == null || processVo.getPageSize() == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        processVo.setPageNo(Integer.valueOf(processVo.getPageNo() + 1));
        InvoiceStatementExportDto dto = this.convertParams(params);
        List<Object> invoiceStatementExportVos = new ArrayList();
        Page pageable = new Page((long)processVo.getPageNo().intValue(), (long)this.getPageSize().intValue());
        Page<InvoiceStatementExportVo> pageAcc = this.invoiceStatementExportMapper.findAccByConditions((Page<InvoiceStatementExportVo>)pageable, dto);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageAcc.getRecords())) {
            pageAcc.getRecords().stream().map(a -> {
                a.setOrdetType("\u9a8c\u6536\u5355");
                return a;
            }).collect(Collectors.toList());
            this.buildVo(pageAcc.getRecords());
            log.info("\u7ed3\u7b97\u5355\u4e0b\u9a8c\u6536\u5355\u6709\uff5b" + pageAcc.getTotal() + "}\u6761");
            invoiceStatementExportVos.addAll(pageAcc.getRecords());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(pageFee = this.invoiceStatementExportMapper.findFeeByConditions((Page<InvoiceStatementExportVo>)pageable, dto)).getRecords())) {
            pageFee.getRecords().stream().map(a -> {
                a.setOrdetType("\u8d39\u7528\u5355");
                return a;
            }).collect(Collectors.toList());
            this.buildVo(pageFee.getRecords());
            log.info("\u7ed3\u7b97\u5355\u4e0b\u8d39\u7528\u5355\u6709\uff5b" + pageFee.getTotal() + "}\u6761");
            invoiceStatementExportVos.addAll(pageFee.getRecords());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(pageReturn = this.invoiceStatementExportMapper.findReturnByConditions((Page<InvoiceStatementExportVo>)pageable, dto)).getRecords())) {
            pageReturn.getRecords().stream().map(a -> {
                a.setOrdetType("\u9000\u8d27\u5355");
                return a;
            }).collect(Collectors.toList());
            this.buildVo(pageReturn.getRecords());
            log.info("\u7ed3\u7b97\u5355\u4e0b\u9000\u8d27\u5355\u6709\uff5b" + pageReturn.getTotal() + "}\u6761");
            invoiceStatementExportVos.addAll(pageReturn.getRecords());
        }
        invoiceStatementExportVos = invoiceStatementExportVos.stream().sorted(Comparator.comparing(InvoiceStatementExportVo::getStatementCode)).collect(Collectors.toList());
        return JSON.parseArray((String)JSON.toJSONString(invoiceStatementExportVos));
    }

    public Class<InvoiceStatementExportVo> findCrmExcelVoClass() {
        return InvoiceStatementExportVo.class;
    }

    public String getBusinessCode() {
        return "KMS_INVOICE_STATEMENT_EXPORT";
    }

    public String getBusinessName() {
        return "KMS\u7ed3\u7b97\u5355\u5bfc\u51fa";
    }

    private InvoiceStatementExportDto convertParams(Map<String, Object> params) {
        params.remove("sort");
        params.remove("europaInfoCode");
        Map<String, Object> map = params.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf("_")), Map.Entry::getValue, (a, b) -> a));
        ArrayList dateList = new ArrayList();
        params.forEach((k, v) -> {
            if (k.contains("order_time")) {
                dateList.add(v.toString());
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dateList)) {
            Collections.sort(dateList);
            if (dateList.size() > 1) {
                map.put("beginDate", dateList.get(0));
                map.put("endDate", dateList.get(1));
            }
        }
        InvoiceStatementExportDto dto = (InvoiceStatementExportDto)((Object)JSON.parseObject((String)JSON.toJSONString(map), InvoiceStatementExportDto.class));
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return dto;
    }

    private void buildVo(List<InvoiceStatementExportVo> page) {
        if (CollectionUtils.isEmpty(page)) {
            return;
        }
        Map<Object, Object> businessFormatMap = new HashMap();
        Map<Object, Object> businessUnitMap = new HashMap();
        Map<Object, Object> bussinessAreaMap = new HashMap();
        Map<Object, Object> orderStatusMap = new HashMap();
        List businessFormat = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        List businessUnit = this.dictDataVoService.findByDictTypeCode("mdm_business_unit");
        List bussinessArea = this.dictDataVoService.findByDictTypeCode("MDM_CUSTOMIZE_ORG");
        List orderStatus = this.dictDataVoService.findByDictTypeCode("kms_order_status");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)businessFormat)) {
            businessFormatMap = businessFormat.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)businessUnit)) {
            businessUnitMap = businessUnit.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)bussinessArea)) {
            bussinessAreaMap = bussinessArea.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderStatus)) {
            orderStatusMap = orderStatus.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        }
        for (InvoiceStatementExportVo invoiceAcceptenceExportVo : page) {
            invoiceAcceptenceExportVo.setBusinessUnitCode((String)businessUnitMap.get(invoiceAcceptenceExportVo.getBusinessUnitCode()));
            invoiceAcceptenceExportVo.setBusinessFormatCode((String)businessFormatMap.get(invoiceAcceptenceExportVo.getBusinessFormatCode()));
            invoiceAcceptenceExportVo.setBusinessArea((String)bussinessAreaMap.get(invoiceAcceptenceExportVo.getBusinessArea()));
            invoiceAcceptenceExportVo.setOrderStatus((String)orderStatusMap.get(invoiceAcceptenceExportVo.getOrderStatus()));
        }
    }
}

