/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementDeduction;
import com.biz.crm.kms.business.invoice.statement.local.mapper.InvoiceStatementDeductionMapper;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDeductionDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceStatementDeductionRepository
extends ServiceImpl<InvoiceStatementDeductionMapper, InvoiceStatementDeduction> {
    public Page<InvoiceStatementDeduction> findByConditions(Pageable pageable, InvoiceStatementDeduction invoiceStatementDeduction) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InvoiceStatementDeduction> pageList = ((InvoiceStatementDeductionMapper)this.baseMapper).findByConditions((Page<InvoiceStatementDeduction>)page, invoiceStatementDeduction);
        return pageList;
    }

    public void deleteDecoment(String statementCode) {
        if (StringUtils.isEmpty((CharSequence)statementCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InvoiceStatementDeduction::getStatementCode, (Object)statementCode)).remove();
    }

    public List<InvoiceStatementDeduction> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<InvoiceStatementDeduction>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(!CollectionUtils.isEmpty(codes), InvoiceStatementDeduction::getDocumentCode, codes)).list();
    }

    public List<String> findKaOrderNumberCode() {
        return ((InvoiceStatementDeductionMapper)this.baseMapper).findKaOrderNumber(TenantUtils.getTenantCode());
    }

    public List<InvoiceStatementDeduction> findByOrderCode(List<String> orderCode) {
        if (CollectionUtils.isEmpty(orderCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(InvoiceStatementDeduction::getDocumentCode, orderCode)).list();
    }

    public void updateStatementCodeByOrderCode(String accOrder, String statementCode) {
        ((InvoiceStatementDeductionMapper)this.baseMapper).updateStatementCodeByOrderCode(accOrder, statementCode);
    }

    public Page<InvoiceStatementDeductionDto> findKmsStatementExpensePage(Pageable pageable, InvoiceStatementDeductionDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InvoiceStatementDeductionDto> pageList = ((InvoiceStatementDeductionMapper)this.baseMapper).findKmsStatementExpensePage((Page<InvoiceStatementDeductionDto>)page, dto);
        return pageList;
    }
}

