/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementReturnOrderDetail;
import com.biz.crm.kms.business.invoice.statement.local.mapper.InvoiceStatementDetailMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceStatementDetailRepository
extends ServiceImpl<InvoiceStatementDetailMapper, InvoiceStatementReturnOrderDetail> {
    public Page<InvoiceStatementReturnOrderDetail> findByConditions(Pageable pageable, InvoiceStatementReturnOrderDetail invoiceStatementAccptance) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InvoiceStatementReturnOrderDetail> pageList = ((InvoiceStatementDetailMapper)this.baseMapper).findByConditions((Page<InvoiceStatementReturnOrderDetail>)page, invoiceStatementAccptance);
        return pageList;
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public List<InvoiceStatementReturnOrderDetail> findBystatementAccptance(String statementCode) {
        if (StringUtils.isBlank((CharSequence)statementCode)) {
            return new ArrayList<InvoiceStatementReturnOrderDetail>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(InvoiceStatementReturnOrderDetail::getStatementCode, (Object)statementCode)).list();
    }

    public void deleteDecoment(String statementCode) {
        if (StringUtils.isEmpty((CharSequence)statementCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InvoiceStatementReturnOrderDetail::getStatementCode, (Object)statementCode)).remove();
    }

    public List<String> findKaOrderNumberCode() {
        return ((InvoiceStatementDetailMapper)this.baseMapper).findKaOrderNumber(TenantUtils.getTenantCode());
    }

    public List<InvoiceStatementReturnOrderDetail> findByOrderCode(List<String> orderCode) {
        if (CollectionUtils.isEmpty(orderCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(InvoiceStatementReturnOrderDetail::getDocumentCode, orderCode)).list();
    }

    public void updateStatementCodeByOrderCode(String returnKaOrder, String statementCode) {
        ((InvoiceStatementDetailMapper)this.baseMapper).updateStatementCodeByOrderCode(returnKaOrder, statementCode);
    }
}

