/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementGrab;
import com.biz.crm.kms.business.invoice.statement.local.mapper.InvoiceStatementGrabMapper;
import com.biz.crm.kms.business.invoice.statement.local.model.StatementGrabConditionModel;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceAcceptanceVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceExpenseSheetVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceReturnOrderVo;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class InvoiceStatementGrabRepository
extends ServiceImpl<InvoiceStatementGrabMapper, InvoiceStatementGrab> {
    @Autowired
    private InvoiceStatementGrabMapper invoiceStatementGrabMapper;

    public Page<String> findStatementGrabPage(Pageable pageable, String tenantCode, List<String> transStatusList, String day) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((InvoiceStatementGrabMapper)this.baseMapper).findStatementGrabPage((Page<String>)page, tenantCode, transStatusList, day);
    }

    public List<InvoiceStatementGrab> findByOrderNumbers(String tenantCode, List<String> orderNumbers) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(InvoiceStatementGrab::getStatementCode, orderNumbers)).list();
    }

    public void updateTransStatusByOrderNumberList(String tenantCode, GrabTransStatus transStatus, List<String> orderNumberList) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || Objects.isNull(transStatus) || CollectionUtil.isEmpty(orderNumberList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(InvoiceStatementGrab::getStatementCode, orderNumberList)).set(InvoiceStatementGrab::getOrderStatus, (Object)transStatus.getDictCode())).update();
    }

    public Page<InvoiceStatementGrab> findByConditions(Pageable pageable, InvoiceStatementGrab invoiceStatementGrab) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InvoiceStatementGrab> pageList = this.invoiceStatementGrabMapper.findByConditions((Page<InvoiceStatementGrab>)page, invoiceStatementGrab);
        return pageList;
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public List<InvoiceStatementGrab> findByInvoiceStatementGrabConditionModel(StatementGrabConditionModel model) {
        return ((InvoiceStatementGrabMapper)this.baseMapper).findByInvoiceStatementGrabConditionModel(model);
    }

    public void updateTransStatusByOrderNumber(String tenantCode, GrabTransStatus transStatus, String orderNumber) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(InvoiceStatementGrab::getStatementCode, (Object)orderNumber)).set(InvoiceStatementGrab::getOrderStatus, (Object)transStatus.getDictCode())).update();
    }

    public InvoiceAcceptanceVo findByAccptanceCode(String orderNumber) {
        return ((InvoiceStatementGrabMapper)this.baseMapper).findByAccptanceCode(orderNumber);
    }

    public InvoiceReturnOrderVo findByReturnOrderCode(String orderNumber) {
        return ((InvoiceStatementGrabMapper)this.baseMapper).findByReturnOrderCode(orderNumber);
    }

    public InvoiceExpenseSheetVo findByExpenseSheetCode(String orderNumber) {
        return ((InvoiceStatementGrabMapper)this.baseMapper).findByExpenseSheetCode(orderNumber);
    }

    public Page<InvoiceAcceptanceVo> findNotMatchAccptance(Pageable pageable, InvoiceAcceptanceVo dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InvoiceAcceptanceVo> pageList = ((InvoiceStatementGrabMapper)this.baseMapper).findNotMatchAccptance((Page<InvoiceAcceptanceVo>)page, dto);
        return pageList;
    }

    public Page<InvoiceReturnOrderVo> findNotMatchReturn(Pageable pageable, InvoiceReturnOrderVo dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InvoiceReturnOrderVo> pageList = ((InvoiceStatementGrabMapper)this.baseMapper).findNotMatchReturn((Page<InvoiceReturnOrderVo>)page, dto);
        return pageList;
    }

    public Page<InvoiceExpenseSheetVo> findNotMatchExpense(Pageable pageable, InvoiceExpenseSheetVo dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InvoiceExpenseSheetVo> pageList = ((InvoiceStatementGrabMapper)this.baseMapper).findNotMatchExpense((Page<InvoiceExpenseSheetVo>)page, dto);
        return pageList;
    }
}

