/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatement;
import com.biz.crm.kms.business.invoice.statement.local.mapper.InvoiceStatementMapper;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementDto;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceStatementDataVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class InvoiceStatementRepository
extends ServiceImpl<InvoiceStatementMapper, InvoiceStatement> {
    @Autowired
    private InvoiceStatementMapper invoiceStatementMapper;

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public List<InvoiceStatement> findByOrderNumberList(String tenantCode, List<String> orderNumberList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(InvoiceStatement::getStatementCode, orderNumberList)).list();
    }

    public List<InvoiceStatement> findInvoiceStatement(InvoiceStatementDto statementDto) {
        return this.invoiceStatementMapper.findInvoiceStatement(statementDto);
    }

    public InvoiceStatement finBystatementCode(String statementCode, String tenantCode) {
        return (InvoiceStatement)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(InvoiceStatement::getStatementCode, (Object)statementCode)).one());
    }

    public List<InvoiceStatement> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public InvoiceStatement findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return new InvoiceStatement();
        }
        return (InvoiceStatement)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).one());
    }

    public Page<InvoiceStatementDto> findInvoiceStatementPaging(Pageable pageable, InvoiceStatementDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InvoiceStatementDto> pageList = this.invoiceStatementMapper.findInvoiceStatementPaging((Page<InvoiceStatementDto>)page, dto);
        return pageList;
    }

    public InvoiceStatement findByStatementCode(String statementCode) {
        return (InvoiceStatement)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(InvoiceStatement::getStatementCode, (Object)statementCode)).one());
    }

    public List<InvoiceStatementDataVo> findAllByConditions(String businessUnitCode, String beginDateStr, String endDateStr) {
        return this.invoiceStatementMapper.findAllByConditions(businessUnitCode, beginDateStr, endDateStr);
    }

    public InvoiceStatementDataVo findByCode(String statementCode, String type) {
        return this.invoiceStatementMapper.findByCode(statementCode, type);
    }

    public List<InvoiceStatementDataVo> findAllByConditions(String date, String businessUnitCode) {
        return this.invoiceStatementMapper.findAllByDate(date, businessUnitCode);
    }
}

