/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.statement.local.entity.StatementDocumentRelation;
import com.biz.crm.kms.business.invoice.statement.local.mapper.StatementDocumentRelationMapper;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceAcceptanceVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceExpenseSheetVo;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceReturnOrderVo;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StatementDocumentRelationRepository
extends ServiceImpl<StatementDocumentRelationMapper, StatementDocumentRelation> {
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public List<StatementDocumentRelation> findByStatement(String statementCode) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(StatementDocumentRelation::getStatementCode, (Object)statementCode)).list();
    }

    public void delectOne(String statementCode, List<String> documentCode, String documentType) {
        if (CollectionUtils.isEmpty(documentCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(StatementDocumentRelation::getStatementCode, (Object)statementCode)).eq(StatementDocumentRelation::getDocumentType, (Object)documentType)).in(StatementDocumentRelation::getDocumentCode, documentCode)).remove();
    }

    public List<StatementDocumentRelation> findByIds(List<String> documentCode) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(StatementDocumentRelation::getDocumentCode, documentCode)).list();
    }

    public List<InvoiceAcceptanceVo> findByAcceptOrderNumber(List<String> acceptList) {
        return ((StatementDocumentRelationMapper)this.baseMapper).findByAcceptOrderNumber(acceptList);
    }

    public List<InvoiceReturnOrderVo> findByReturnOrderNumber(List<String> returnList) {
        return ((StatementDocumentRelationMapper)this.baseMapper).findByReturnOrderNumber(returnList);
    }

    public List<InvoiceExpenseSheetVo> findByExceptOrderNumber(List<String> expenseList) {
        return ((StatementDocumentRelationMapper)this.baseMapper).findByExceptOrderNumber(expenseList);
    }
}

