/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import com.biz.crm.kms.business.invoice.sdk.enums.AutoConvertsEnum;
import com.biz.crm.kms.business.invoice.sdk.enums.ConstantEnums;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatement;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementAccptance;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementAccptanceGrab;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementDeduction;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementDeductionGrab;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementGrab;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementReturnOrderDetail;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementReturnOrderDetailGrab;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementAccptanceGrabRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementDeductionGrabRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementDeductionRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementDetailGrabRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementGrabRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementRepository;
import com.biz.crm.kms.business.invoice.statement.local.service.InvoiceStatementGrabService;
import com.biz.crm.kms.business.invoice.statement.local.service.InvoiceStatementGrabThreadService;
import com.biz.crm.kms.business.invoice.statement.sdk.constant.InvoiceStatementConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.service.RedisCrmService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="invoiceStatementGrabService")
public class InvoiceStatementGrabServiceImpl
implements InvoiceStatementGrabService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatementGrabServiceImpl.class);
    @Autowired(required=false)
    private InvoiceStatementGrabRepository invoiceStatementGrabRepository;
    @Autowired(required=false)
    private InvoiceStatementGrabThreadService invoiceStatementGrabThreadService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private RedisCrmService redisCrmService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private InvoiceStatementAccptanceGrabRepository accptanceGrabRepository;
    @Autowired(required=false)
    private InvoiceStatementDeductionGrabRepository expenseSheetRepository;
    @Autowired(required=false)
    private InvoiceStatementDetailGrabRepository returnorderRepository;
    @Autowired(required=false)
    private InvoiceStatementRepository invoiceStatementRepository;
    @Autowired(required=false)
    private DirectStoreVoService directStoreVoService;
    @Autowired(required=false)
    private DirectVoService directVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private InvoiceExpenseSheetVoService invoiceExpenseSheetVoService;
    @Autowired(required=false)
    private InvoiceStatementDeductionRepository invoiceStatementDeductionRepository;

    @Override
    public Page<InvoiceStatementGrab> findByConditions(Pageable pageable, InvoiceStatementGrab invoiceStatementGrab) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull((Object)invoiceStatementGrab)) {
            invoiceStatementGrab = new InvoiceStatementGrab();
        }
        return this.invoiceStatementGrabRepository.findByConditions(pageable, invoiceStatementGrab);
    }

    @Override
    public InvoiceStatementGrab findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (InvoiceStatementGrab)((Object)this.invoiceStatementGrabRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public InvoiceStatementGrab create(InvoiceStatementGrab invoiceStatementGrab) {
        this.createValidate(invoiceStatementGrab);
        this.invoiceStatementGrabRepository.saveOrUpdate((Object)invoiceStatementGrab);
        return invoiceStatementGrab;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public InvoiceStatementGrab update(InvoiceStatementGrab invoiceStatementGrab) {
        this.updateValidate(invoiceStatementGrab);
        this.invoiceStatementGrabRepository.saveOrUpdate((Object)invoiceStatementGrab);
        return invoiceStatementGrab;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceStatementGrabRepository.removeByIds(idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceStatementGrabRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceStatementGrabRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoNotConvertStatement() {
        log.info("=====>    \u7ed3\u7b97\u5355\u672a\u8f6c\u6362\u5355\u636e\u5b9a\u65f6\u4efb\u52a1\u81ea\u52a8\u8f6c\u6362 start   <=====");
        boolean lock = this.redisMutexService.tryLock("KMS:STATEMENT:AUTO_NOT_CONVERT:LOCK", TimeUnit.SECONDS, InvoiceStatementConstant.STATEMENT_REDIS_TIME.intValue());
        if (!lock) {
            log.warn("\u7ed3\u7b97\u5355\u672a\u8f6c\u6362\u5355\u636e\u5b9a\u65f6\u4efb\u52a1\u81ea\u52a8\u8f6c\u6362\u4e2d,\u672c\u6b21\u81ea\u52a8\u8f6c\u6362\u88ab\u5ffd\u7565!");
            log.info("=====>    \u7ed3\u7b97\u5355\u672a\u8f6c\u6362\u5355\u636e\u5b9a\u65f6\u4efb\u52a1\u81ea\u52a8\u8f6c\u6362 end   <=====");
            return;
        }
        PageRequest pageable = PageRequest.of((int)1, (int)InvoiceStatementConstant.STATEMENT_PAGE_SIZE);
        ArrayList<String> transStatusList = new ArrayList<String>();
        transStatusList.add(GrabTransStatus.NOT_TRANS.getDictCode());
        String day = this.getDays(AutoConvertsEnum.NOT_CONVERTS.getDictCode());
        HashSet currentOrderNumberSet = new HashSet(InvoiceStatementConstant.STATEMENT_PAGE_SIZE);
        try {
            Page<String> orderNumberPage = this.invoiceStatementGrabRepository.findStatementGrabPage((Pageable)pageable, TenantUtils.getTenantCode(), transStatusList, day);
            currentOrderNumberSet.addAll(orderNumberPage.getRecords());
            this.sendMqMessage(orderNumberPage.getRecords());
            while (orderNumberPage.hasNext() && InvoiceStatementConstant.STATEMENT_LOOP_MAX >= pageable.getPageNumber()) {
                pageable = pageable.next();
                orderNumberPage = this.invoiceStatementGrabRepository.findStatementGrabPage((Pageable)pageable, TenantUtils.getTenantCode(), transStatusList, day);
                currentOrderNumberSet.clear();
                currentOrderNumberSet.addAll(orderNumberPage.getRecords());
                this.sendMqMessage(orderNumberPage.getRecords());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            if (CollectionUtil.isNotEmpty(currentOrderNumberSet)) {
                this.redisCrmService.hdel("KMS:STATEMENT:CONVERT:LOCK", currentOrderNumberSet.toArray());
            }
        }
        finally {
            this.redisMutexService.unlock("KMS:STATEMENT:AUTO_NOT_CONVERT:LOCK");
        }
        log.info("=====>    \u7ed3\u7b97\u5355\u672a\u8f6c\u6362\u5355\u636e\u5b9a\u65f6\u4efb\u52a1\u81ea\u52a8\u8f6c\u6362 end   <=====");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoFailConvertStatement() {
        log.info("=====>    \u7ed3\u7b97\u5355\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362 start   <=====");
        boolean lock = this.redisMutexService.tryLock("KMS:STATEMENT:AUTO_FAIL_CONVERT:LOCK", TimeUnit.SECONDS, InvoiceStatementConstant.STATEMENT_REDIS_TIME.intValue());
        if (!lock) {
            log.warn("\u7ed3\u7b97\u5355\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362\u4e2d,\u672c\u6b21\u81ea\u52a8\u8f6c\u6362\u88ab\u5ffd\u7565!");
            log.info("=====>    \u7ed3\u7b97\u5355\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
            return;
        }
        Pageable pageable = Pageable.ofSize((int)InvoiceStatementConstant.STATEMENT_PAGE_SIZE);
        ArrayList<String> transStatusList = new ArrayList<String>();
        transStatusList.add(GrabTransStatus.NOT_TRANS.getDictCode());
        String day = this.getDays(AutoConvertsEnum.FAIL_CONVERTS.getDictCode());
        HashSet currentOrderNumberSet = new HashSet(InvoiceStatementConstant.STATEMENT_PAGE_SIZE);
        try {
            Page<String> orderNumberPage = this.invoiceStatementGrabRepository.findStatementGrabPage(pageable, TenantUtils.getTenantCode(), transStatusList, day);
            currentOrderNumberSet.addAll(orderNumberPage.getRecords());
            this.sendMqMessage(orderNumberPage.getRecords());
            while (orderNumberPage.hasNext() && InvoiceStatementConstant.STATEMENT_LOOP_MAX >= pageable.getPageNumber()) {
                pageable = pageable.next();
                orderNumberPage = this.invoiceStatementGrabRepository.findStatementGrabPage(pageable, TenantUtils.getTenantCode(), transStatusList, day);
                currentOrderNumberSet.clear();
                currentOrderNumberSet.addAll(orderNumberPage.getRecords());
                this.sendMqMessage(orderNumberPage.getRecords());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            if (CollectionUtil.isNotEmpty(currentOrderNumberSet)) {
                this.redisCrmService.hdel("KMS:STATEMENT:CONVERT:LOCK", currentOrderNumberSet.toArray());
            }
        }
        finally {
            this.redisMutexService.unlock("KMS:STATEMENT:AUTO_FAIL_CONVERT:LOCK");
        }
        log.info("=====>    \u7ed3\u7b97\u5355\u8f6c\u6362\u5931\u8d25\u5355\u636e\u81ea\u52a8\u8f6c\u6362 end   <=====");
    }

    private void sendMqMessage(List<String> orderNumberList) {
        if (CollectionUtils.isEmpty(orderNumberList)) {
            return;
        }
        if (CollectionUtils.isEmpty(orderNumberList = orderNumberList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList()))) {
            log.error("\u7ed3\u7b97\u5355\u539f\u59cb\u5355\u636e\u6709\u7a7a\u5355\u53f7[statement_code]\u5b58\u5728!");
            return;
        }
        this.filterSwitchIngOrderNumberList(orderNumberList);
        if (CollectionUtil.isEmpty(orderNumberList)) {
            return;
        }
        MqMessageVo message = new MqMessageVo();
        message.setMsgBody(JSON.toJSONString(orderNumberList));
        message.setTopic("KMS_STATEMENT_TOPIC" + RocketMqUtil.mqEnvironment());
        message.setTag("KMS_STATEMENT_MESSAGE_TAG");
        this.rocketMqProducer.sendMqMsg(message);
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void manualSwitch(List<String> orderNumberList) {
        if (CollectionUtil.isEmpty(orderNumberList)) {
            log.warn("\u672a\u63a5\u6536\u5230\u9700\u8f6c\u6362\u7ed3\u7b97\u5355\u53f7\uff01");
            return;
        }
        List<InvoiceStatement> orderList = this.buildOrder(orderNumberList);
        this.convertOrder(orderList);
    }

    private List<InvoiceStatement> buildOrder(List<String> orderNumberList) {
        log.info("--  \u7ec4\u88c5\u5355\u636e  --");
        if (CollectionUtil.isEmpty(orderNumberList)) {
            return Collections.emptyList();
        }
        List<InvoiceStatementGrab> entityGrabList = this.invoiceStatementGrabRepository.findByOrderNumbers(TenantUtils.getTenantCode(), orderNumberList);
        if (CollectionUtil.isEmpty(entityGrabList)) {
            log.warn("\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01");
            return Collections.emptyList();
        }
        int defaultVersionNumber = 1;
        entityGrabList.forEach(entity -> {
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (Objects.isNull(entity.getVersionNumber())) {
                entity.setVersionNumber(defaultVersionNumber);
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getKaTotalAmountStr())) {
                BigDecimal kaTotalAmount = new BigDecimal(entity.getKaTotalAmountStr());
                entity.setKaTotalAmount(kaTotalAmount);
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getStatementSingleTicketStr())) {
                BigDecimal statementSingleTicket = new BigDecimal(entity.getStatementSingleTicketStr());
                entity.setStatementSingleTicket(statementSingleTicket);
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getStatementSingleAccountStr())) {
                BigDecimal statementSingleAccount = new BigDecimal(entity.getStatementSingleAccountStr());
                entity.setStatementSingleAccount(statementSingleAccount);
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getStatementAmountStr())) {
                BigDecimal statementAmount = new BigDecimal(entity.getStatementAmountStr());
                entity.setStatementAmount(statementAmount);
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getStatementAmountNotStr())) {
                BigDecimal statementAmountNot = new BigDecimal(entity.getStatementAmountNotStr());
                entity.setStatementAmountNot(statementAmountNot);
            }
        });
        List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityGrabList, InvoiceStatementGrab.class, InvoiceStatement.class, HashSet.class, ArrayList.class, new String[0]);
        Map entityMap = entityList.stream().collect(Collectors.toMap(InvoiceStatement::getStatementCode, Function.identity(), (a, b) -> a.getVersionNumber() > b.getVersionNumber() ? a : b));
        ArrayList<InvoiceStatement> convertData = new ArrayList(entityMap.values());
        convertData = convertData.stream().filter(f -> Objects.nonNull(f.getVersionNumber())).collect(Collectors.toList());
        convertData = this.convertStatementDeducion(convertData, orderNumberList);
        return convertData;
    }

    @Override
    public void convertOrder(List<InvoiceStatement> entityList) {
        log.info("--  \u5355\u636e\u6240\u9700\u6570\u636e\u67e5\u8be2  --");
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        if (CollectionUtils.isEmpty(entityList = entityList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getStatementCode())).collect(Collectors.toList()))) {
            return;
        }
        ArrayList orderNumberList = Lists.newArrayList();
        HashSet<String> directCodeSet = new HashSet<String>();
        HashSet<String> supermarketStoreCodes = new HashSet<String>();
        entityList.forEach(entity -> {
            orderNumberList.add(entity.getStatementCode());
            if (StringUtils.isNotBlank((CharSequence)entity.getDirectCode())) {
                directCodeSet.add(entity.getDirectCode());
            }
        });
        List directVos = this.directVoService.findByDirectCodes(directCodeSet.stream().collect(Collectors.toList()));
        HashMap directMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)directVos)) {
            directMap.putAll(directVos.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)k.getBusinessFormatCode())).collect(Collectors.groupingBy(DirectVo::getDirectCode)));
        }
        BigDecimal tax = new BigDecimal(100);
        List<String> dictCodes = this.findGXDirectCode();
        Map fomatMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"kms_gx_seller_login"}));
        List solds = (List)fomatMap.get("kms_gx_seller_login");
        entityList.forEach(aa -> {
            Optional<String> soldCode = solds.stream().filter(a -> a.getDictCode().equals(aa.getUserName())).map(DictDataVo::getDictValue).findFirst();
            Optional<String> soldName = solds.stream().filter(a -> a.getDictCode().equals(aa.getUserName())).map(DictDataVo::getDictDesc).findFirst();
            Optional<String> bussinessArea = solds.stream().filter(a -> a.getDictCode().equals(aa.getUserName())).map(DictDataVo::getExt1).findFirst();
            aa.setSoldToPartyCode(soldCode.orElse(""));
            aa.setSoldToPartyName(soldName.orElse(""));
            aa.setBusinessArea(bussinessArea.orElse(""));
            if (CollectionUtil.isNotEmpty(aa.getAccptanceList())) {
                aa.getAccptanceList().forEach(accptance -> supermarketStoreCodes.add(accptance.getSupermarketStoreCode()));
            }
            if (CollectionUtil.isNotEmpty(aa.getDeductionList())) {
                aa.getDeductionList().forEach(accptance -> supermarketStoreCodes.add(accptance.getSupermarketStoreCode()));
            }
            if (CollectionUtil.isNotEmpty(aa.getAccptanceList())) {
                aa.getAccptanceList().forEach(accptance -> supermarketStoreCodes.add(accptance.getSupermarketStoreCode()));
            }
            if (dictCodes.contains(aa.getDirectCode())) {
                if (aa.getStatementCode().contains("KP")) {
                    aa.setQueryCode(aa.getStatementCode().split("-")[2]);
                }
                if (!CollectionUtils.isEmpty(aa.getAccptanceList())) {
                    aa.getAccptanceList().forEach(accptance -> {
                        if (ObjectUtils.isNotEmpty((Object)accptance.getGxDiscountAmountNot()) && BigDecimal.ZERO.compareTo(accptance.getGxDiscountAmountNot()) != 0 && ObjectUtils.isNotEmpty((Object)accptance.getGxTaxRate())) {
                            accptance.setGxDiscountAmount(accptance.getGxDiscountAmountNot().multiply(accptance.getGxTaxRate().divide(tax, 4, 4).add(BigDecimal.ONE)));
                        }
                        if (ObjectUtils.isNotEmpty((Object)accptance.getDocumentAmountNot()) && BigDecimal.ZERO.compareTo(accptance.getDocumentAmountNot()) != 0 && ObjectUtils.isNotEmpty((Object)accptance.getGxTaxRate())) {
                            accptance.setDocumentAmount(accptance.getDocumentAmountNot().multiply(accptance.getGxTaxRate().divide(tax, 4, 4).add(BigDecimal.ONE)));
                        }
                    });
                }
                if (!CollectionUtils.isEmpty(aa.getDeductionList())) {
                    this.transExpenseAmount((InvoiceStatement)((Object)aa));
                }
                if (!CollectionUtils.isEmpty(aa.getAccptanceList())) {
                    String documentCode = aa.getStatementCode() + "-0000001";
                    List<Object> deductionList = new ArrayList();
                    if (!CollectionUtils.isEmpty(aa.getDeductionList())) {
                        deductionList = aa.getDeductionList();
                    }
                    InvoiceStatementDeduction expense = new InvoiceStatementDeduction();
                    expense.setTenantCode(TenantUtils.getTenantCode());
                    expense.setStatementCode(aa.getStatementCode());
                    expense.setDocumentCode(documentCode);
                    expense.setAmount(BigDecimal.ZERO);
                    expense.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                    aa.getAccptanceList().forEach(accptance -> {
                        if (Objects.nonNull(accptance.getGxDiscountAmount())) {
                            expense.setAmount(expense.getAmount().add(accptance.getGxDiscountAmountNot().multiply(BigDecimal.ONE.add(accptance.getGxTaxRate().divide(new BigDecimal(100))))));
                        }
                        expense.setCreateTime(accptance.getCreateTime());
                    });
                    deductionList.add((Object)expense);
                    aa.setDeductionList(deductionList);
                }
            }
        });
        Map<String, List<DirectStoreVo>> directStoreMap = this.buildStoreInfo(directCodeSet, supermarketStoreCodes);
        HashSet deliveryPartyCodeSet = Sets.newHashSet();
        if (CollectionUtil.isNotEmpty(directStoreMap)) {
            directStoreMap.values().stream().filter(CollUtil::isNotEmpty).forEach(directStoreVoList -> directStoreVoList.forEach(entity -> deliveryPartyCodeSet.add(entity.getTerminalCode())));
        }
        entityList = this.updateOldDataToNewData(orderNumberList, entityList);
        List entityGroupList = Lists.partition(entityList, (int)ConstantEnums.THREAD_SIZE.getValue());
        entityGroupList.stream().filter(CollUtil::isNotEmpty).forEach(asyncList -> this.invoiceStatementGrabThreadService.saveStatementOrderData((List<InvoiceStatement>)asyncList, directMap, directStoreMap));
    }

    private List<InvoiceStatement> convertStatementDeducion(List<InvoiceStatement> invoiceStatementList, List<String> orderNumberList) {
        log.info("\u67e5\u8be2\u7ed3\u7b97\u5355\u7684\u9a8c\u6536\u5355\u3001\u9000\u8d27\u5355\u3001\u8d39\u7528\u5355\u7684\u6570\u636e\uff01");
        List<InvoiceStatementAccptance> accptanceList = this.findAccByStatementCodes(orderNumberList);
        HashMap accMap = CollectionUtil.isNotEmpty(accptanceList) ? accptanceList.stream().collect(Collectors.groupingBy(InvoiceStatementAccptance::getStatementCode)) : new HashMap();
        List<InvoiceStatementDeduction> expenseList = this.findFeeByStatementCodes(orderNumberList);
        HashMap feeMap = CollectionUtil.isNotEmpty(expenseList) ? expenseList.stream().collect(Collectors.groupingBy(InvoiceStatementDeduction::getStatementCode)) : new HashMap();
        List<InvoiceStatementReturnOrderDetail> returnList = this.findReturbByStatementCodes(orderNumberList);
        HashMap returnMap = CollectionUtil.isNotEmpty(returnList) ? returnList.stream().collect(Collectors.groupingBy(InvoiceStatementReturnOrderDetail::getStatementCode)) : new HashMap();
        invoiceStatementList.forEach(entity -> {
            List<InvoiceStatementAccptance> accptances = (List<InvoiceStatementAccptance>)accMap.get(entity.getStatementCode());
            List<InvoiceStatementDeduction> fees = (List<InvoiceStatementDeduction>)feeMap.get(entity.getStatementCode());
            List<InvoiceStatementReturnOrderDetail> returns = (List<InvoiceStatementReturnOrderDetail>)returnMap.get(entity.getStatementCode());
            if (CollectionUtil.isNotEmpty((Collection)accptances)) {
                accptances = accptanceList.stream().filter(f -> entity.getVersionNumber().compareTo(f.getVersionNumber()) == 0).collect(Collectors.toList());
                entity.setAccptanceList(accptances);
            }
            if (CollectionUtil.isNotEmpty((Collection)fees)) {
                fees = fees.stream().filter(f -> entity.getVersionNumber().compareTo(f.getVersionNumber()) == 0).collect(Collectors.toList());
                entity.setDeductionList(fees);
            }
            if (CollectionUtil.isNotEmpty((Collection)returns)) {
                returns = returns.stream().filter(f -> entity.getVersionNumber().compareTo(f.getVersionNumber()) == 0).collect(Collectors.toList());
                entity.setReturnOrderDetails(returns);
            }
        });
        return invoiceStatementList;
    }

    private List<InvoiceStatementAccptance> findAccByStatementCodes(List<String> statementCode) {
        List<InvoiceStatementAccptanceGrab> accptanceGrabList = this.accptanceGrabRepository.findBystatementAccptances(statementCode);
        log.info("\u9a8c\u6536\u5355\u7684\u6570\u91cf\u6709{" + accptanceGrabList.size() + "}\u6761");
        if (CollectionUtils.isEmpty(accptanceGrabList)) {
            return null;
        }
        accptanceGrabList.forEach(a -> {
            a.setId(null);
            if (StringUtils.isNotBlank((CharSequence)a.getDocumentAmountStr())) {
                BigDecimal documentAmount = new BigDecimal(a.getDocumentAmountStr());
                a.setDocumentAmount(documentAmount);
            }
            if (StringUtils.isNotBlank((CharSequence)a.getDocumentAmountNotStr())) {
                BigDecimal documentAmountNot = new BigDecimal(a.getDocumentAmountNotStr());
                a.setDocumentAmountNot(documentAmountNot);
            }
        });
        List<InvoiceStatementAccptance> invoiceStatementAccptances = (List<InvoiceStatementAccptance>)this.nebulaToolkitService.copyCollectionByWhiteList(accptanceGrabList, InvoiceStatementAccptanceGrab.class, InvoiceStatementAccptance.class, HashSet.class, ArrayList.class, new String[0]);
        invoiceStatementAccptances = invoiceStatementAccptances.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getVersionNumber())).collect(Collectors.toList());
        return invoiceStatementAccptances;
    }

    private List<InvoiceStatementDeduction> findFeeByStatementCodes(List<String> statementCode) {
        Map nullCashingMap;
        List<InvoiceStatementDeductionGrab> feeGrabList = this.expenseSheetRepository.findBystatementExpenses(statementCode);
        log.info("\u8d39\u7528\u5355\u7684\u6570\u91cf\u6709{" + feeGrabList.size() + "}\u6761");
        if (CollectionUtils.isEmpty(feeGrabList)) {
            return null;
        }
        feeGrabList.forEach(b -> b.setId(null));
        List<InvoiceStatementDeduction> expenselist = (List<InvoiceStatementDeduction>)this.nebulaToolkitService.copyCollectionByWhiteList(feeGrabList, InvoiceStatementDeductionGrab.class, InvoiceStatementDeduction.class, HashSet.class, ArrayList.class, new String[0]);
        Set nullCashing = expenselist.stream().filter(f -> StringUtils.isBlank((CharSequence)f.getCashingType())).map(InvoiceStatementDeduction::getDocumentCode).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(nullCashing) && Objects.nonNull(nullCashingMap = this.invoiceExpenseSheetVoService.findCashing(nullCashing))) {
            expenselist.forEach(expense -> {
                String cashing = (String)nullCashingMap.get(expense.getDocumentCode());
                if (StringUtils.isEmpty((CharSequence)cashing)) {
                    return;
                }
                expense.setCashingType(cashing);
            });
        }
        expenselist = expenselist.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getVersionNumber())).collect(Collectors.toList());
        return expenselist;
    }

    private List<InvoiceStatementReturnOrderDetail> findReturbByStatementCodes(List<String> statementCode) {
        List<InvoiceStatementReturnOrderDetailGrab> returnOrderGrabList = this.returnorderRepository.findBystatementReturns(statementCode);
        log.info("\u9000\u8d27\u5355\u7684\u6570\u91cf\u6709{" + returnOrderGrabList.size() + "}\u6761");
        if (CollectionUtils.isEmpty(returnOrderGrabList)) {
            // empty if block
        }
        returnOrderGrabList.forEach(c -> c.setId(null));
        List<InvoiceStatementReturnOrderDetail> returnOrderDetailList = (List<InvoiceStatementReturnOrderDetail>)this.nebulaToolkitService.copyCollectionByWhiteList(returnOrderGrabList, InvoiceStatementReturnOrderDetailGrab.class, InvoiceStatementReturnOrderDetail.class, HashSet.class, ArrayList.class, new String[0]);
        returnOrderDetailList = returnOrderDetailList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getVersionNumber())).collect(Collectors.toList());
        return returnOrderDetailList;
    }

    private Map<String, List<DirectStoreVo>> buildStoreInfo(Set<String> directCodeSet, Set<String> kaStoreCodes) {
        HashMap directStoreMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(kaStoreCodes) || CollectionUtil.isEmpty(directCodeSet)) {
            return directStoreMap;
        }
        DirectStoreConditionDto conditionDto = new DirectStoreConditionDto();
        conditionDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        conditionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        conditionDto.setSupermarketStoreCodes(kaStoreCodes);
        conditionDto.setDirectCodes(directCodeSet);
        List directStoreList = this.directStoreVoService.findByDirectStoreConditionDto(conditionDto);
        log.info("\u67e5\u8be2\u7cfb\u7edf\u95e8\u5e97{" + directStoreList.size() + "}\u6761\uff01");
        if (CollectionUtil.isNotEmpty((Collection)directStoreList)) {
            directStoreMap.putAll(directStoreList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDirectCode())).filter(k -> StringUtils.isNotBlank((CharSequence)k.getSupermarketStoreCode())).collect(Collectors.groupingBy(k -> k.getDirectCode() + "_" + k.getSupermarketStoreCode())));
        }
        return directStoreMap;
    }

    private List<InvoiceStatement> updateOldDataToNewData(List<String> orderNumberList, List<InvoiceStatement> entityList) {
        if (CollectionUtil.isEmpty(orderNumberList) || CollectionUtil.isEmpty(entityList)) {
            return entityList;
        }
        List<InvoiceStatement> oldEntityList = this.invoiceStatementRepository.findByOrderNumberList(TenantUtils.getTenantCode(), orderNumberList);
        Map<String, InvoiceStatement> oldMap = oldEntityList.stream().collect(Collectors.toMap(InvoiceStatement::getStatementCode, v -> v, (oldValue, newValue) -> newValue));
        log.info("\u67e5\u8be2\u51fa\u5df2\u8f6c\u6362\u7684\u7ed3\u7b97\u5355\u6709:{" + oldEntityList.size() + "}\u6761\uff01");
        entityList.forEach(entity -> {
            InvoiceStatement oldEntity = (InvoiceStatement)((Object)((Object)oldMap.get(entity.getStatementCode())));
            if (oldEntity != null) {
                entity.setId(oldEntity.getId());
                entity.setOrderStatus(oldEntity.getOrderStatus());
            } else {
                entity.setId(null);
            }
        });
        return entityList;
    }

    @Override
    public void filterSwitchIngOrderNumberList(List<String> orderNumberList) {
        if (CollectionUtil.isEmpty(orderNumberList)) {
            return;
        }
        List updateList = this.redisCrmService.hmget("KMS:STATEMENT:CONVERT:LOCK", new HashSet<String>(orderNumberList));
        log.info("\u83b7\u53d6\u5230\u7f13\u5b58\u6709{" + updateList.size() + "}\u6761\uff01");
        if (CollectionUtil.isNotEmpty((Collection)updateList)) {
            orderNumberList.removeAll(updateList.stream().filter(Objects::nonNull).filter(k -> StringUtils.isNotEmpty((CharSequence)k.toString())).map(Object::toString).collect(Collectors.toList()));
        }
        Map<String, String> redisMap = orderNumberList.stream().collect(Collectors.toMap(key -> key, key -> key, (oldValue, newValue) -> newValue));
        this.redisCrmService.hmset("KMS:STATEMENT:CONVERT:LOCK", redisMap, TimeUnit.SECONDS, (long)InvoiceStatementConstant.STATEMENT_REDIS_TIME.intValue());
    }

    private void createValidate(InvoiceStatementGrab invoiceStatementGrab) {
        Validate.notNull((Object)((Object)invoiceStatementGrab), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        invoiceStatementGrab.setId(null);
    }

    private void updateValidate(InvoiceStatementGrab invoiceStatementGrab) {
        Validate.notNull((Object)((Object)invoiceStatementGrab), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private String getDays(String type) {
        Map fomatMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"kms_auto_converts"}));
        List vos = (List)fomatMap.get("kms_auto_converts");
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(type)).map(DictDataVo::getDictValue).findFirst();
        int past = Integer.parseInt(first.orElse(""));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.get(5) - past);
        String day = sdf.format(calendar.getTime());
        return day;
    }

    private void transExpenseAmount(InvoiceStatement entity) {
        if (CollectionUtils.isEmpty(entity.getDeductionList()) || CollectionUtils.isEmpty(entity.getAccptanceList())) {
            log.info("\u9ad8\u946b\u7ed3\u7b97\u5355\u4e0b\u7684\u9a8c\u6536\u5355\u8be6\u60c5\u6216\u8d39\u7528\u5355\u8be6\u60c5\u4e3a\u7a7a\uff01");
            return;
        }
        Set taxs = entity.getAccptanceList().stream().map(InvoiceStatementAccptance::getGxTaxRate).collect(Collectors.toSet());
        BigDecimal decomentTax = entity.getAccptanceList().get(0).getGxDiscountRate().divide(new BigDecimal(100));
        if (taxs.size() == 1) {
            BigDecimal tax = ((BigDecimal)taxs.stream().collect(Collectors.toList()).get(0)).divide(new BigDecimal(100));
            entity.getDeductionList().forEach(a -> {
                if (Objects.isNull(a.getAmount()) || Objects.nonNull(a.getAmount()) && BigDecimal.ZERO.compareTo(a.getAmount()) == 0) {
                    a.setAmount(a.getAmountNot().multiply(tax.add(BigDecimal.ONE)));
                }
            });
        } else {
            BigDecimal minTax = entity.getAccptanceList().stream().map(InvoiceStatementAccptance::getGxTaxRate).min((x1, x2) -> x1.compareTo((BigDecimal)x2)).get();
            BigDecimal expenseTotal = entity.getDeductionList().stream().map(InvoiceStatementDeduction::getAmountNot).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal acceptTotal = entity.getAccptanceList().stream().filter(f -> minTax.equals(f.getGxTaxRate())).map(InvoiceStatementAccptance::getDocumentAmountNot).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal rebatesAmountTotal = acceptTotal.divide(BigDecimal.ONE.subtract(decomentTax), 4, 4);
            BigDecimal rebatesAmount = rebatesAmountTotal.multiply(decomentTax);
            BigDecimal apportionmentAmount = rebatesAmountTotal.divide(new BigDecimal(2), 4, 4).subtract(rebatesAmount);
            if (apportionmentAmount.compareTo(expenseTotal) == 1 || apportionmentAmount.compareTo(expenseTotal) == 0) {
                entity.getDeductionList().forEach(a -> a.setAmount(a.getAmountNot().multiply(minTax.divide(new BigDecimal(100)).add(BigDecimal.ONE))));
                return;
            }
            BigDecimal maxTax = entity.getAccptanceList().stream().map(InvoiceStatementAccptance::getGxTaxRate).max((x1, x2) -> x1.compareTo((BigDecimal)x2)).get().divide(new BigDecimal(100));
            BigDecimal minTaxAmount = apportionmentAmount.multiply(minTax.divide(new BigDecimal(100)));
            BigDecimal maxTaxAmount = expenseTotal.subtract(apportionmentAmount).multiply(maxTax);
            BigDecimal totalTaxAmount = minTaxAmount.add(maxTaxAmount);
            entity.getDeductionList().forEach(a -> {
                BigDecimal amountOne = a.getAmountNot().multiply(totalTaxAmount);
                BigDecimal amount = amountOne.divide(expenseTotal, 4, 4);
                if (Objects.isNull(a.getAmount()) || Objects.nonNull(a.getAmount()) && BigDecimal.ZERO.compareTo(a.getAmount()) == 0) {
                    a.setAmount(amount.add(a.getAmountNot()));
                }
            });
        }
    }

    private List<String> findGXDirectCode() {
        Map fomatMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"direct_gx"}));
        log.info("\u9ad8\u946b\u7cfb\u7edf\u7f16\u7801\u6709{" + fomatMap.size() + "}\u6761\uff01");
        List vos = (List)fomatMap.get("direct_gx");
        List<String> dictCodes = vos.stream().map(DictDataVo::getDictCode).collect(Collectors.toList());
        return dictCodes;
    }

    @Override
    public void syncAutoExpense() {
        List<String> directCodes = this.findGXDirectCode();
        List expenseCodes = this.invoiceExpenseSheetVoService.syncExpense(directCodes);
        if (CollectionUtils.isEmpty((Collection)expenseCodes)) {
            return;
        }
        List<InvoiceStatementDeduction> expenses = this.invoiceStatementDeductionRepository.findByCodes(expenseCodes);
        if (!CollectionUtils.isEmpty(expenses)) {
            Map<String, BigDecimal> amounts = expenses.stream().collect(Collectors.toMap(InvoiceStatementDeduction::getDocumentCode, InvoiceStatementDeduction::getAmount));
            this.invoiceExpenseSheetVoService.updateExpense(amounts, expenseCodes);
        }
    }

    @Override
    public void syncExpense(List<String> codes) {
        if (Objects.isNull(codes)) {
            throw new RuntimeException("\u672a\u4f20\u5165\u8d39\u7528\u5355\u7f16\u7801");
        }
        List<InvoiceStatementDeduction> expenses = this.invoiceStatementDeductionRepository.findByCodes(codes);
        if (Objects.isNull(expenses)) {
            throw new RuntimeException("\u8be5\u8d39\u7528\u5355\u5728\u7ed3\u7b97\u5355\u7684\u8d39\u7528\u8be6\u60c5\u4e2d\u4e0d\u5b58\u5728");
        }
        expenses.forEach(f -> {
            if (BigDecimal.ZERO.compareTo(f.getAmount()) > 0) {
                f.setAmount(f.getAmount().negate());
            }
        });
        Map<String, BigDecimal> amounts = expenses.stream().collect(Collectors.toMap(InvoiceStatementDeduction::getDocumentCode, InvoiceStatementDeduction::getAmount));
        this.invoiceExpenseSheetVoService.updateExpense(amounts, codes);
    }
}

