/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.statement.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatement;
import com.biz.crm.kms.business.invoice.statement.local.entity.InvoiceStatementDeduction;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementAccptanceRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementDeductionRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementDetailRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementGrabRepository;
import com.biz.crm.kms.business.invoice.statement.local.repository.InvoiceStatementRepository;
import com.biz.crm.kms.business.invoice.statement.local.service.InvoiceStatementGrabThreadService;
import com.biz.crm.kms.business.invoice.statement.sdk.enums.ExistStatus;
import com.biz.crm.kms.business.invoice.statement.sdk.enums.InvoiceStatementStatus;
import com.biz.crm.mn.common.base.service.RedisCrmService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceStatementGrabThreadServiceImpl
implements InvoiceStatementGrabThreadService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatementGrabThreadServiceImpl.class);
    @Autowired(required=false)
    private RedisCrmService redisCrmService;
    @Autowired(required=false)
    private InvoiceStatementRepository invoiceStatementRepository;
    @Autowired(required=false)
    private InvoiceStatementGrabRepository invoiceStatementGrabRepository;
    @Autowired(required=false)
    private InvoiceStatementAccptanceRepository accptanceRepository;
    @Autowired(required=false)
    private InvoiceStatementDeductionRepository expenseRepository;
    @Autowired(required=false)
    private InvoiceStatementDetailRepository returnOrderRepository;

    @Override
    @Async(value="grab2Thread")
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void saveStatementOrderData(List<InvoiceStatement> entities, Map<String, List<DirectVo>> directMap, Map<String, List<DirectStoreVo>> directStoreMap) {
        log.info("--  \u8fdb\u5165\u7ebf\u7a0b\u6c60\u5b58\u50a8\u6570\u636e  --");
        if (CollectionUtil.isEmpty(entities)) {
            return;
        }
        ArrayList orderNumbers = new ArrayList();
        HashSet orderNumberSet = new HashSet();
        HashSet orderNumberSuccessSet = new HashSet();
        entities.stream().filter(Objects::nonNull).filter(k -> StringUtils.isNotBlank((CharSequence)k.getStatementCode())).forEach(entity -> {
            try {
                List directVos;
                this.redisCrmService.hdel("KMS:STATEMENT:CONVERT:LOCK", new Object[]{entity.getStatementCode()});
                if (StringUtils.isNotBlank((CharSequence)entity.getStatementDate())) {
                    try {
                        entity.setOrderTime(new SimpleDateFormat("yyyy-MM-dd").parse(entity.getStatementDate()));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (CollectionUtils.isEmpty((Collection)(directVos = (List)directMap.get(entity.getDirectCode())))) {
                    entity.setOrderStatusMsg("\u4e0d\u5b58\u5728\u8be5\u7cfb\u7edf");
                } else {
                    DirectVo directVo = (DirectVo)directVos.get(0);
                    entity.setBusinessFormatCode(directVo.getBusinessFormatCode());
                    entity.setBusinessUnitCode(directVo.getBusinessUnitCode());
                    entity.setDirectCode(directVo.getDirectCode());
                    entity.setKaCode(directVo.getSupermarketCode());
                    entity.setKaName(directVo.getSupermarketName());
                }
                this.buildShoreInfo((InvoiceStatement)((Object)entity), directStoreMap);
                this.buildOrderStatus((InvoiceStatement)((Object)entity));
                this.invoiceStatementRepository.saveOrUpdate(entity);
                if (Objects.equals(InvoicesStatus.S200.getDictCode(), entity.getOrderStatus())) {
                    orderNumberSuccessSet.add(entity.getStatementCode());
                } else {
                    orderNumberSet.add(entity.getStatementCode());
                }
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u7ed3\u7b97\u5355\u6570\u636e\u5931\u8d25", (Throwable)e);
                entity.setOrderStatus(InvoicesStatus.S100.getDictCode());
                entity.setOrderStatusMsg("\u4fdd\u5b58\u7ed3\u7b97\u5355\u6570\u636e\u5931\u8d25");
                try {
                    this.invoiceStatementRepository.saveOrUpdate(entity);
                    orderNumberSet.add(entity.getStatementCode());
                }
                catch (Exception ex) {
                    log.error("", (Throwable)ex);
                }
            }
        });
        if (CollectionUtil.isEmpty(orderNumberSet) && CollectionUtils.isEmpty(orderNumberSuccessSet)) {
            return;
        }
        this.redisCrmService.hdel("KMS:STATEMENT:CONVERT:LOCK", new Object[]{orderNumbers});
        try {
            if (!CollectionUtils.isEmpty(orderNumberSet)) {
                this.invoiceStatementGrabRepository.updateTransStatusByOrderNumberList(TenantUtils.getTenantCode(), GrabTransStatus.TRANS_FAIL, new ArrayList<String>(orderNumberSet));
            }
            if (!CollectionUtils.isEmpty(orderNumberSuccessSet)) {
                this.invoiceStatementGrabRepository.updateTransStatusByOrderNumberList(TenantUtils.getTenantCode(), GrabTransStatus.HAVE_TRANS, new ArrayList<String>(orderNumberSuccessSet));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void buildShoreInfo(InvoiceStatement entity, Map<String, List<DirectStoreVo>> directStoreMap) {
        BigDecimal finalStatementAmountNot;
        BigDecimal statementAmount;
        entity.setOrderStatus(InvoicesStatus.S100.getDictCode());
        AtomicReference<BigDecimal> finalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> finalAmountNot = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> finalAccAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> finalAccAmountNot = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> finalReturnAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> finalReturnAmountNot = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> statementSingleTicket = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> statementSingleAccount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> kaTotalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        entity.setOrderStatus(InvoicesStatus.S200.getDictCode());
        if (!CollectionUtils.isEmpty(entity.getAccptanceList())) {
            entity.getAccptanceList().forEach(aa -> {
                BigDecimal documentAmountNot;
                BigDecimal documentAmount = aa.getDocumentAmount();
                if (Objects.nonNull(documentAmount)) {
                    finalAmount.set(((BigDecimal)finalAmount.get()).add(documentAmount));
                    finalAccAmount.set(((BigDecimal)finalAccAmount.get()).add(documentAmount));
                }
                if (Objects.nonNull(documentAmountNot = aa.getDocumentAmountNot())) {
                    finalAmountNot.set(((BigDecimal)finalAmountNot.get()).add(documentAmountNot));
                    finalAccAmountNot.set(((BigDecimal)finalAccAmountNot.get()).add(documentAmountNot));
                }
                if (StringUtils.isBlank((CharSequence)aa.getSupermarketStoreCode())) {
                    return;
                }
                List directStoreVoList = (List)directStoreMap.get(entity.getDirectCode() + "_" + aa.getSupermarketStoreCode());
                if (CollectionUtils.isEmpty((Collection)directStoreVoList)) {
                    entity.setOrderStatusMsg("\u8be5\u7ed3\u7b97\u5355\u4e0b\u7684\u9a8c\u6536\u5355\u4e2d\u7684\u96f6\u552e\u5546\u95e8\u5e97\u65e0\u5bf9\u5e94\u76f4\u8425\u95e8\u5e97\u5173\u7cfb");
                    return;
                }
                if (StringUtils.isBlank((CharSequence)entity.getSoldToPartyCode())) {
                    DirectStoreVo directStoreVo = (DirectStoreVo)directStoreVoList.get(0);
                    aa.setTerminalCode(directStoreVo.getTerminalCode());
                    aa.setTerminalName(directStoreVo.getTerminalName());
                    if (StringUtils.isBlank((CharSequence)aa.getSupermarketStoreName())) {
                        aa.setSupermarketStoreName(directStoreVo.getSupermarketStoreName());
                    }
                } else {
                    List directStoreVos = directStoreVoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getSoldToPartyCode())).filter(f -> f.getSoldToPartyCode().equals(entity.getSoldToPartyCode())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(directStoreVos)) {
                        entity.setOrderStatusMsg("\u8be5\u552e\u8fbe\u65b9\u6ca1\u6709\u5bf9\u5e94\u7684\u76f4\u8425\u95e8\u5e97");
                        return;
                    }
                    DirectStoreVo directStoreVo = (DirectStoreVo)directStoreVos.get(0);
                    aa.setTerminalCode(directStoreVo.getTerminalCode());
                    aa.setTerminalName(directStoreVo.getTerminalName());
                }
            });
        }
        if (!CollectionUtils.isEmpty(entity.getDeductionList())) {
            BigDecimal totalAmount = entity.getDeductionList().stream().filter(f -> !f.getDocumentCode().equals(f.getStatementCode() + "-0000001")).filter(f -> Objects.nonNull(f.getAmount())).map(InvoiceStatementDeduction::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            kaTotalAmount.set(kaTotalAmount.get().add(totalAmount));
            entity.getDeductionList().forEach(cc -> {
                if (Objects.nonNull(cc.getCashingType())) {
                    if (ExistStatus.CASHING_P.getDes().equals(cc.getCashingType())) {
                        statementSingleTicket.set(((BigDecimal)statementSingleTicket.get()).add(cc.getAmount()));
                    } else if (ExistStatus.CASHING_Z.getDes().equals(cc.getCashingType())) {
                        statementSingleAccount.set(((BigDecimal)statementSingleAccount.get()).add(cc.getAmount()));
                    }
                }
                if (Objects.nonNull(cc.getAmount()) && BigDecimal.ZERO.compareTo(cc.getAmount()) < 0) {
                    cc.setAmount(cc.getAmount().negate());
                }
                if (Objects.nonNull(cc.getAmountNot()) && BigDecimal.ZERO.compareTo(cc.getAmountNot()) < 0) {
                    cc.setAmountNot(cc.getAmountNot().negate());
                }
                if (StringUtils.isBlank((CharSequence)cc.getSupermarketStoreCode())) {
                    return;
                }
                List directStoreVoList = (List)directStoreMap.get(entity.getDirectCode() + "_" + cc.getSupermarketStoreCode());
                if (CollectionUtils.isEmpty((Collection)directStoreVoList)) {
                    return;
                }
                if (StringUtils.isBlank((CharSequence)entity.getSoldToPartyCode())) {
                    DirectStoreVo directStoreVo = (DirectStoreVo)directStoreVoList.get(0);
                    cc.setTerminalCode(directStoreVo.getTerminalCode());
                    cc.setTerminalName(directStoreVo.getTerminalName());
                    if (StringUtils.isBlank((CharSequence)cc.getSupermarketStoreName())) {
                        cc.setSupermarketStoreName(directStoreVo.getSupermarketStoreName());
                    }
                } else {
                    DirectStoreVo directStoreVo = (DirectStoreVo)directStoreVoList.stream().filter(f -> f.getSoldToPartyCode().equals(entity.getSoldToPartyCode())).collect(Collectors.toList()).get(0);
                    if (Objects.isNull(directStoreVo)) {
                        entity.setOrderStatusMsg("\u8be5\u552e\u8fbe\u65b9\u4e0b\u6ca1\u6709\u5bf9\u5e94\u7684\u76f4\u8425\u95e8\u5e97");
                        return;
                    }
                    cc.setTerminalCode(directStoreVo.getTerminalCode());
                    cc.setTerminalName(directStoreVo.getTerminalName());
                    if (StringUtils.isBlank((CharSequence)cc.getSupermarketStoreName())) {
                        cc.setSupermarketStoreName(directStoreVo.getSupermarketStoreName());
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(entity.getReturnOrderDetails())) {
            entity.getReturnOrderDetails().forEach(bb -> {
                BigDecimal documentAmountNot;
                BigDecimal documentAmount = bb.getDocumentAmount();
                if (Objects.nonNull(documentAmount)) {
                    finalAmount.set(((BigDecimal)finalAmount.get()).add(documentAmount));
                    finalReturnAmount.set(((BigDecimal)finalReturnAmount.get()).add(documentAmount));
                }
                if (Objects.nonNull(documentAmountNot = bb.getDocumentAmountNot())) {
                    finalAmountNot.set(((BigDecimal)finalAmountNot.get()).add(documentAmountNot));
                    finalReturnAmountNot.set(((BigDecimal)finalReturnAmountNot.get()).add(documentAmountNot));
                }
                if (StringUtils.isBlank((CharSequence)bb.getSupermarketStoreCode())) {
                    return;
                }
                List directStoreVoList = (List)directStoreMap.get(entity.getDirectCode() + "_" + bb.getSupermarketStoreCode());
                if (CollectionUtils.isEmpty((Collection)directStoreVoList)) {
                    return;
                }
                if (StringUtils.isBlank((CharSequence)entity.getSoldToPartyCode())) {
                    DirectStoreVo directStoreVo = (DirectStoreVo)directStoreVoList.get(0);
                    bb.setTerminalCode(directStoreVo.getTerminalCode());
                    bb.setTerminalName(directStoreVo.getTerminalName());
                    if (StringUtils.isBlank((CharSequence)bb.getSupermarketStoreName())) {
                        bb.setSupermarketStoreName(directStoreVo.getSupermarketStoreName());
                    }
                } else {
                    List directStoreVos = directStoreVoList.stream().filter(f -> f.getSoldToPartyCode().equals(entity.getSoldToPartyCode())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(directStoreVos)) {
                        entity.setOrderStatusMsg("\u8be5\u552e\u8fbe\u65b9\u4e0b\u6ca1\u6709\u5bf9\u5e94\u7684\u76f4\u8425\u95e8\u5e97");
                        return;
                    }
                    DirectStoreVo directStoreVo = (DirectStoreVo)directStoreVos.get(0);
                    bb.setTerminalCode(directStoreVo.getTerminalCode());
                    bb.setTerminalName(directStoreVo.getTerminalName());
                    if (StringUtils.isBlank((CharSequence)bb.getSupermarketStoreName())) {
                        bb.setSupermarketStoreName(directStoreVo.getSupermarketStoreName());
                    }
                }
            });
        }
        if (StringUtils.isBlank((CharSequence)entity.getSoldToPartyCode())) {
            if (CollectionUtil.isNotEmpty(directStoreMap) && !CollectionUtils.isEmpty(entity.getAccptanceList())) {
                List<DirectStoreVo> directStoreVos = directStoreMap.get(entity.getDirectCode() + "_" + entity.getAccptanceList().get(0).getSupermarketStoreCode());
                if (!CollectionUtils.isEmpty(directStoreVos)) {
                    DirectStoreVo directStoreVo = directStoreVos.get(0);
                    if (StringUtils.isNotBlank((CharSequence)directStoreVo.getSoldToPartyCode())) {
                        entity.setSoldToPartyName(directStoreVo.getSoldToPartyName());
                        entity.setSoldToPartyCode(directStoreVo.getSoldToPartyCode());
                        entity.setBusinessArea(directStoreVo.getBusinessArea());
                    } else {
                        entity.setOrderStatus(InvoicesStatus.S100.getDictCode());
                        entity.setOrderStatusMsg("\u8be5\u7ed3\u7b97\u5355\u4e0b\u7684\u9a8c\u6536\u5355\u4e2d\u7684\u95e8\u5e97\u627e\u4e0d\u5230\u552e\u8fbe\u65b9");
                    }
                } else {
                    entity.setOrderStatus(InvoicesStatus.S100.getDictCode());
                    entity.setOrderStatusMsg("\u8be5\u7ed3\u7b97\u5355\u4e0b\u7684\u9a8c\u6536\u5355\u4e2d\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
                }
            } else {
                entity.setOrderStatusMsg("\u8be5\u7ed3\u7b97\u5355\u4e0b\u7684\u9a8c\u6536\u5355\u4e2d\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
            }
        }
        if (Objects.isNull(statementAmount = entity.getStatementAmount()) || BigDecimal.ZERO.compareTo(statementAmount) == 0 && BigDecimal.ZERO.compareTo(finalAmount.get()) != 0) {
            entity.setStatementAmount(finalAmount.get());
        }
        if (Objects.isNull(finalStatementAmountNot = entity.getStatementAmountNot()) || BigDecimal.ZERO.compareTo(finalStatementAmountNot) == 0 && BigDecimal.ZERO.compareTo(finalAmountNot.get()) != 0) {
            entity.setStatementAmountNot(finalAmountNot.get());
        }
        if (Objects.isNull(entity.getStatementAccAmount()) && BigDecimal.ZERO.compareTo(finalAccAmount.get()) != 0) {
            entity.setStatementAccAmount(finalAmount.get());
        }
        if (Objects.isNull(entity.getStatementAccAmountNot()) && BigDecimal.ZERO.compareTo(finalAccAmountNot.get()) != 0) {
            entity.setStatementAccAmountNot(finalAccAmountNot.get());
        }
        if (Objects.isNull(entity.getStatementReturnAmount()) && BigDecimal.ZERO.compareTo(finalReturnAmount.get()) != 0) {
            entity.setStatementReturnAmount(finalAmount.get());
        }
        if (Objects.isNull(entity.getStatementReturnAmountNot()) && BigDecimal.ZERO.compareTo(finalReturnAmountNot.get()) != 0) {
            entity.setStatementReturnAmountNot(finalAccAmountNot.get());
        }
        if (Objects.isNull(entity.getStatementSingleTicket()) || BigDecimal.ZERO.compareTo(entity.getStatementSingleTicket()) == 0 && BigDecimal.ZERO.compareTo(statementSingleTicket.get()) != 0) {
            entity.setStatementSingleTicket(statementSingleTicket.get());
        }
        if (Objects.isNull(entity.getStatementSingleAccount()) || BigDecimal.ZERO.compareTo(entity.getStatementSingleAccount()) == 0 && BigDecimal.ZERO.compareTo(statementSingleAccount.get()) != 0) {
            entity.setStatementSingleAccount(statementSingleAccount.get());
        }
        if (Objects.isNull(entity.getKaTotalAmount()) || BigDecimal.ZERO.compareTo(entity.getKaTotalAmount()) == 0 && BigDecimal.ZERO.compareTo(kaTotalAmount.get()) != 0) {
            entity.setKaTotalAmount(kaTotalAmount.get());
        }
        this.accptanceRepository.deleteDecoment(entity.getStatementCode());
        this.expenseRepository.deleteDecoment(entity.getStatementCode());
        this.returnOrderRepository.deleteDecoment(entity.getStatementCode());
        this.accptanceRepository.saveBatch(entity.getAccptanceList());
        this.expenseRepository.saveBatch(entity.getDeductionList());
        this.returnOrderRepository.saveBatch(entity.getReturnOrderDetails());
        entity.setOrderStatus(InvoicesStatus.S200.getDictCode());
    }

    public void buildOrderStatus(InvoiceStatement entity) {
        long accErrorCount = 0L;
        long feeErrorCount = 0L;
        long returnErrorCount = 0L;
        if (CollectionUtil.isNotEmpty(entity.getAccptanceList())) {
            accErrorCount = entity.getAccptanceList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getSupermarketStoreCode())).filter(f -> StringUtils.isBlank((CharSequence)f.getTerminalCode())).count();
        }
        if (CollectionUtil.isNotEmpty(entity.getDeductionList())) {
            feeErrorCount = entity.getDeductionList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getSupermarketStoreCode())).filter(f -> StringUtils.isBlank((CharSequence)f.getTerminalCode())).count();
        }
        if (CollectionUtil.isNotEmpty(entity.getReturnOrderDetails())) {
            returnErrorCount = entity.getReturnOrderDetails().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getSupermarketStoreCode())).filter(f -> StringUtils.isBlank((CharSequence)f.getTerminalCode())).count();
        }
        String orderStatusMsg = entity.getOrderStatusMsg();
        if (accErrorCount > 0L) {
            orderStatusMsg = StringUtils.isNotBlank((CharSequence)orderStatusMsg) ? String.format("%s||%s", orderStatusMsg, "\u8be5\u7ed3\u7b97\u5355\u4e0b\u9a8c\u6536\u5355\u4e2d\u95e8\u5e97\u6570\u636e\u6709\u672a\u5339\u914d\u9001\u8fbe\u65b9") : "\u8be5\u7ed3\u7b97\u5355\u4e0b\u9a8c\u6536\u5355\u4e2d\u95e8\u5e97\u6570\u636e\u6709\u672a\u5339\u914d\u9001\u8fbe\u65b9";
        }
        entity.setOrderStatusMsg(orderStatusMsg);
        if (feeErrorCount > 0L) {
            orderStatusMsg = StringUtils.isNotBlank((CharSequence)orderStatusMsg) ? String.format("%s||%s", orderStatusMsg, "\u8be5\u7ed3\u7b97\u5355\u4e0b\u8d39\u7528\u5355\u4e2d\u95e8\u5e97\u6570\u636e\u6709\u672a\u5339\u914d\u9001\u8fbe\u65b9") : "\u8be5\u7ed3\u7b97\u5355\u4e0b\u8d39\u7528\u5355\u4e2d\u95e8\u5e97\u6570\u636e\u6709\u672a\u5339\u914d\u9001\u8fbe\u65b9";
        }
        entity.setOrderStatusMsg(orderStatusMsg);
        if (returnErrorCount > 0L) {
            orderStatusMsg = StringUtils.isNotBlank((CharSequence)orderStatusMsg) ? String.format("%s||%s", orderStatusMsg, "\u8be5\u7ed3\u7b97\u5355\u4e0b\u9000\u8d27\u5355\u4e2d\u95e8\u5e97\u6570\u636e\u6709\u672a\u5339\u914d\u9001\u8fbe\u65b9") : "\u8be5\u7ed3\u7b97\u5355\u4e0b\u9000\u8d27\u5355\u4e2d\u95e8\u5e97\u6570\u636e\u6709\u672a\u5339\u914d\u9001\u8fbe\u65b9";
        }
        entity.setOrderStatusMsg(orderStatusMsg);
        if (StringUtils.isNotBlank((CharSequence)entity.getOrderStatusMsg())) {
            entity.setOrderStatus(InvoicesStatus.S100.getDictCode());
        } else if (Objects.equals(InvoiceStatementStatus.S200.getDictCode(), entity.getOrderStatus())) {
            entity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
        }
    }
}

